// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.GetLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.LegalHoldStatus
import aws.sdk.kotlin.services.backup.model.RecoveryPointSelection
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetLegalHoldOperationDeserializer: HttpDeserialize<GetLegalHoldResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLegalHoldResponse {
        if (!response.status.isSuccess()) {
            throwGetLegalHoldError(context, response)
        }
        val builder = GetLegalHoldResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLegalHoldOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLegalHoldError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLegalHoldOperationBody(builder: GetLegalHoldResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CANCELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CancelDescription"))
    val CANCELLATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CancellationDate"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LEGALHOLDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LegalHoldArn"))
    val LEGALHOLDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LegalHoldId"))
    val RECOVERYPOINTSELECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RecoveryPointSelection"))
    val RETAINRECORDUNTIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("RetainRecordUntil"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Title"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CANCELDESCRIPTION_DESCRIPTOR)
        field(CANCELLATIONDATE_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LEGALHOLDARN_DESCRIPTOR)
        field(LEGALHOLDID_DESCRIPTOR)
        field(RECOVERYPOINTSELECTION_DESCRIPTOR)
        field(RETAINRECORDUNTIL_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CANCELDESCRIPTION_DESCRIPTOR.index -> builder.cancelDescription = deserializeString()
                CANCELLATIONDATE_DESCRIPTOR.index -> builder.cancellationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LEGALHOLDARN_DESCRIPTOR.index -> builder.legalHoldArn = deserializeString()
                LEGALHOLDID_DESCRIPTOR.index -> builder.legalHoldId = deserializeString()
                RECOVERYPOINTSELECTION_DESCRIPTOR.index -> builder.recoveryPointSelection = deserializeRecoveryPointSelectionDocument(deserializer)
                RETAINRECORDUNTIL_DESCRIPTOR.index -> builder.retainRecordUntil = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LegalHoldStatus.fromValue(it) }
                TITLE_DESCRIPTOR.index -> builder.title = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
