// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.backupgateway.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.backupgateway.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Backup gateway
 * Backup gateway connects Backup to your hypervisor, so you can create, store, and restore backups of your virtual machines (VMs) anywhere, whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.
 *
 * Add on-premises resources by connecting to a hypervisor through a gateway. Backup will automatically discover the resources in your hypervisor.
 *
 * Use Backup to assign virtual or on-premises resources to a backup plan, or run on-demand backups. Once you have backed up your resources, you can view them and restore them like any resource supported by Backup.
 *
 * To download the Amazon Web Services software to get started, navigate to the Backup console, choose **Gateways**, then choose **Create gateway**.
 */
interface BackupGatewayClient : SdkClient {

    override val serviceName: String
        get() = "Backup Gateway"
    /**
     * BackupGatewayClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): BackupGatewayClient {
            val config = Config.Builder().apply(block).build()
            return DefaultBackupGatewayClient(config)
        }

        operator fun invoke(config: Config): BackupGatewayClient = DefaultBackupGatewayClient(config)

        /**
         * Construct a [BackupGatewayClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): BackupGatewayClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultBackupGatewayClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
     */
    suspend fun associateGatewayToServer(input: AssociateGatewayToServerRequest): AssociateGatewayToServerResponse

    /**
     * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
     */
    suspend fun associateGatewayToServer(block: AssociateGatewayToServerRequest.Builder.() -> Unit) = associateGatewayToServer(AssociateGatewayToServerRequest.Builder().apply(block).build())

    /**
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
     */
    suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse

    /**
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
     */
    suspend fun createGateway(block: CreateGatewayRequest.Builder.() -> Unit) = createGateway(CreateGatewayRequest.Builder().apply(block).build())

    /**
     * Deletes a backup gateway.
     */
    suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deletes a backup gateway.
     */
    suspend fun deleteGateway(block: DeleteGatewayRequest.Builder.() -> Unit) = deleteGateway(DeleteGatewayRequest.Builder().apply(block).build())

    /**
     * Deletes a hypervisor.
     */
    suspend fun deleteHypervisor(input: DeleteHypervisorRequest): DeleteHypervisorResponse

    /**
     * Deletes a hypervisor.
     */
    suspend fun deleteHypervisor(block: DeleteHypervisorRequest.Builder.() -> Unit) = deleteHypervisor(DeleteHypervisorRequest.Builder().apply(block).build())

    /**
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
     */
    suspend fun disassociateGatewayFromServer(input: DisassociateGatewayFromServerRequest): DisassociateGatewayFromServerResponse

    /**
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
     */
    suspend fun disassociateGatewayFromServer(block: DisassociateGatewayFromServerRequest.Builder.() -> Unit) = disassociateGatewayFromServer(DisassociateGatewayFromServerRequest.Builder().apply(block).build())

    /**
     * Connect to a hypervisor by importing its configuration.
     */
    suspend fun importHypervisorConfiguration(input: ImportHypervisorConfigurationRequest): ImportHypervisorConfigurationResponse

    /**
     * Connect to a hypervisor by importing its configuration.
     */
    suspend fun importHypervisorConfiguration(block: ImportHypervisorConfigurationRequest.Builder.() -> Unit) = importHypervisorConfiguration(ImportHypervisorConfigurationRequest.Builder().apply(block).build())

    /**
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
     */
    suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse

    /**
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
     */
    suspend fun listGateways(block: ListGatewaysRequest.Builder.() -> Unit) = listGateways(ListGatewaysRequest.Builder().apply(block).build())

    /**
     * Lists your hypervisors.
     */
    suspend fun listHypervisors(input: ListHypervisorsRequest): ListHypervisorsResponse

    /**
     * Lists your hypervisors.
     */
    suspend fun listHypervisors(block: ListHypervisorsRequest.Builder.() -> Unit) = listHypervisors(ListHypervisorsRequest.Builder().apply(block).build())

    /**
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists your virtual machines.
     */
    suspend fun listVirtualMachines(input: ListVirtualMachinesRequest): ListVirtualMachinesResponse

    /**
     * Lists your virtual machines.
     */
    suspend fun listVirtualMachines(block: ListVirtualMachinesRequest.Builder.() -> Unit) = listVirtualMachines(ListVirtualMachinesRequest.Builder().apply(block).build())

    /**
     * Set the maintenance start time for a gateway.
     */
    suspend fun putMaintenanceStartTime(input: PutMaintenanceStartTimeRequest): PutMaintenanceStartTimeResponse

    /**
     * Set the maintenance start time for a gateway.
     */
    suspend fun putMaintenanceStartTime(block: PutMaintenanceStartTimeRequest.Builder.() -> Unit) = putMaintenanceStartTime(PutMaintenanceStartTimeRequest.Builder().apply(block).build())

    /**
     * Tag the resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tag the resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
     */
    suspend fun testHypervisorConfiguration(input: TestHypervisorConfigurationRequest): TestHypervisorConfigurationResponse

    /**
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
     */
    suspend fun testHypervisorConfiguration(block: TestHypervisorConfigurationRequest.Builder.() -> Unit) = testHypervisorConfiguration(TestHypervisorConfigurationRequest.Builder().apply(block).build())

    /**
     * Removes tags from the resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from the resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
     */
    suspend fun updateGatewayInformation(input: UpdateGatewayInformationRequest): UpdateGatewayInformationResponse

    /**
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
     */
    suspend fun updateGatewayInformation(block: UpdateGatewayInformationRequest.Builder.() -> Unit) = updateGatewayInformation(UpdateGatewayInformationRequest.Builder().apply(block).build())

    /**
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
     */
    suspend fun updateHypervisor(input: UpdateHypervisorRequest): UpdateHypervisorResponse

    /**
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
     */
    suspend fun updateHypervisor(block: UpdateHypervisorRequest.Builder.() -> Unit) = updateHypervisor(UpdateHypervisorRequest.Builder().apply(block).build())
}
