// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.backupgateway.model.*
import aws.sdk.kotlin.services.backupgateway.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Backup Gateway"
const val ServiceApiVersion: String = "2021-01-01"
const val SdkVersion: String = "0.15.2-beta"

internal class DefaultBackupGatewayClient(override val config: BackupGatewayClient.Config) : BackupGatewayClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
     */
    override suspend fun associateGatewayToServer(input: AssociateGatewayToServerRequest): AssociateGatewayToServerResponse {
        val op = SdkHttpOperation.build<AssociateGatewayToServerRequest, AssociateGatewayToServerResponse> {
            serializer = AssociateGatewayToServerOperationSerializer()
            deserializer = AssociateGatewayToServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateGatewayToServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the `AssociateGatewayToServer` operation.
     */
    override suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse {
        val op = SdkHttpOperation.build<CreateGatewayRequest, CreateGatewayResponse> {
            serializer = CreateGatewayOperationSerializer()
            deserializer = CreateGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a backup gateway.
     */
    override suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse {
        val op = SdkHttpOperation.build<DeleteGatewayRequest, DeleteGatewayResponse> {
            serializer = DeleteGatewayOperationSerializer()
            deserializer = DeleteGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a hypervisor.
     */
    override suspend fun deleteHypervisor(input: DeleteHypervisorRequest): DeleteHypervisorResponse {
        val op = SdkHttpOperation.build<DeleteHypervisorRequest, DeleteHypervisorResponse> {
            serializer = DeleteHypervisorOperationSerializer()
            deserializer = DeleteHypervisorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteHypervisor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
     */
    override suspend fun disassociateGatewayFromServer(input: DisassociateGatewayFromServerRequest): DisassociateGatewayFromServerResponse {
        val op = SdkHttpOperation.build<DisassociateGatewayFromServerRequest, DisassociateGatewayFromServerResponse> {
            serializer = DisassociateGatewayFromServerOperationSerializer()
            deserializer = DisassociateGatewayFromServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateGatewayFromServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Connect to a hypervisor by importing its configuration.
     */
    override suspend fun importHypervisorConfiguration(input: ImportHypervisorConfigurationRequest): ImportHypervisorConfigurationResponse {
        val op = SdkHttpOperation.build<ImportHypervisorConfigurationRequest, ImportHypervisorConfigurationResponse> {
            serializer = ImportHypervisorConfigurationOperationSerializer()
            deserializer = ImportHypervisorConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportHypervisorConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
     */
    override suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse {
        val op = SdkHttpOperation.build<ListGatewaysRequest, ListGatewaysResponse> {
            serializer = ListGatewaysOperationSerializer()
            deserializer = ListGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your hypervisors.
     */
    override suspend fun listHypervisors(input: ListHypervisorsRequest): ListHypervisorsResponse {
        val op = SdkHttpOperation.build<ListHypervisorsRequest, ListHypervisorsResponse> {
            serializer = ListHypervisorsOperationSerializer()
            deserializer = ListHypervisorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListHypervisors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your virtual machines.
     */
    override suspend fun listVirtualMachines(input: ListVirtualMachinesRequest): ListVirtualMachinesResponse {
        val op = SdkHttpOperation.build<ListVirtualMachinesRequest, ListVirtualMachinesResponse> {
            serializer = ListVirtualMachinesOperationSerializer()
            deserializer = ListVirtualMachinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVirtualMachines"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Set the maintenance start time for a gateway.
     */
    override suspend fun putMaintenanceStartTime(input: PutMaintenanceStartTimeRequest): PutMaintenanceStartTimeResponse {
        val op = SdkHttpOperation.build<PutMaintenanceStartTimeRequest, PutMaintenanceStartTimeResponse> {
            serializer = PutMaintenanceStartTimeOperationSerializer()
            deserializer = PutMaintenanceStartTimeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutMaintenanceStartTime"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tag the resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
     */
    override suspend fun testHypervisorConfiguration(input: TestHypervisorConfigurationRequest): TestHypervisorConfigurationResponse {
        val op = SdkHttpOperation.build<TestHypervisorConfigurationRequest, TestHypervisorConfigurationResponse> {
            serializer = TestHypervisorConfigurationOperationSerializer()
            deserializer = TestHypervisorConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestHypervisorConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from the resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
     */
    override suspend fun updateGatewayInformation(input: UpdateGatewayInformationRequest): UpdateGatewayInformationResponse {
        val op = SdkHttpOperation.build<UpdateGatewayInformationRequest, UpdateGatewayInformationResponse> {
            serializer = UpdateGatewayInformationOperationSerializer()
            deserializer = UpdateGatewayInformationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGatewayInformation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
     */
    override suspend fun updateHypervisor(input: UpdateHypervisorRequest): UpdateHypervisorResponse {
        val op = SdkHttpOperation.build<UpdateHypervisorRequest, UpdateHypervisorResponse> {
            serializer = UpdateHypervisorOperationSerializer()
            deserializer = UpdateHypervisorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateHypervisor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("BackupOnPremises_v20210101", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup-gateway"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "backup-gateway")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
