// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.paginators

import aws.sdk.kotlin.services.backupgateway.BackupGatewayClient
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesRequest
import aws.sdk.kotlin.services.backupgateway.model.ListVirtualMachinesResponse
import aws.sdk.kotlin.services.backupgateway.model.VirtualMachine
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListVirtualMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVirtualMachinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualMachinesResponse]
 */
fun BackupGatewayClient.listVirtualMachinesPaginated(initialRequest: ListVirtualMachinesRequest): Flow<ListVirtualMachinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVirtualMachinesPaginated.listVirtualMachines(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListVirtualMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualMachinesResponse]
 */
fun BackupGatewayClient.listVirtualMachinesPaginated(block: ListVirtualMachinesRequest.Builder.() -> Unit): Flow<ListVirtualMachinesResponse> =
    listVirtualMachinesPaginated(ListVirtualMachinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVirtualMachinesPaginated]
 * to access the nested member [VirtualMachine]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VirtualMachine]
 */
@JvmName("listVirtualMachinesResponseVirtualMachine")
fun Flow<ListVirtualMachinesResponse>.virtualMachines(): Flow<VirtualMachine> =
    transform() { response ->
        response.virtualMachines?.forEach {
            emit(it)
        }
    }
