// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backupgateway.model



/**
 * Represents the hypervisor's permissions to which the gateway will connect.
 *
 * A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
 */
public class Hypervisor private constructor(builder: Builder) {
    /**
     * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     */
    public val host: kotlin.String? = builder.host
    /**
     * The Amazon Resource Name (ARN) of the hypervisor.
     */
    public val hypervisorArn: kotlin.String? = builder.hypervisorArn
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the hypervisor.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The state of the hypervisor.
     */
    public val state: aws.sdk.kotlin.services.backupgateway.model.HypervisorState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backupgateway.model.Hypervisor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Hypervisor(")
        append("host=$host,")
        append("hypervisorArn=$hypervisorArn,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = host?.hashCode() ?: 0
        result = 31 * result + (hypervisorArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Hypervisor

        if (host != other.host) return false
        if (hypervisorArn != other.hypervisorArn) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backupgateway.model.Hypervisor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         */
        public var host: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the hypervisor.
         */
        public var hypervisorArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the hypervisor.
         */
        public var name: kotlin.String? = null
        /**
         * The state of the hypervisor.
         */
        public var state: aws.sdk.kotlin.services.backupgateway.model.HypervisorState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backupgateway.model.Hypervisor) : this() {
            this.host = x.host
            this.hypervisorArn = x.hypervisorArn
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backupgateway.model.Hypervisor = Hypervisor(this)
    }
}
