// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.batch.model.*
import aws.sdk.kotlin.services.batch.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Batch"
public const val ServiceApiVersion: String = "2016-08-10"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultBatchClient(override val config: BatchClient.Config) : BatchClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Cancels a job in an Batch job queue. Jobs that are in the `SUBMITTED`, `PENDING`, or `RUNNABLE` state are canceled. Jobs that progressed to the `STARTING` or `RUNNING` state aren't canceled. However, the API operation still succeeds, even if no job is canceled. These jobs must be terminated with the TerminateJob operation.
     */
    override suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse {
        val op = SdkHttpOperation.build<CancelJobRequest, CancelJobResponse> {
            serializer = CancelJobOperationSerializer()
            deserializer = CancelJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Batch compute environment. You can create `MANAGED` or `UNMANAGED` compute environments. `MANAGED` compute environments can use Amazon EC2 or Fargate resources. `UNMANAGED` compute environments can only use EC2 resources.
     *
     * In a managed compute environment, Batch manages the capacity and instance types of the compute resources within the environment. This is based on the compute resource specification that you define or the [launch template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) that you specify when you create the compute environment. Either, you can choose to use EC2 On-Demand Instances and EC2 Spot Instances. Or, you can use Fargate and Fargate Spot capacity in your managed compute environment. You can optionally set a maximum price so that Spot Instances only launch when the Spot Instance price is less than a specified percentage of the On-Demand price.
     *
     * Multi-node parallel jobs aren't supported on Spot Instances.
     *
     * In an unmanaged compute environment, you can manage your own EC2 compute resources and have flexibility with how you configure your compute resources. For example, you can use custom AMIs. However, you must verify that each of your AMIs meet the Amazon ECS container instance AMI specification. For more information, see [container instance AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html) in the *Amazon Elastic Container Service Developer Guide*. After you created your unmanaged compute environment, you can use the DescribeComputeEnvironments operation to find the Amazon ECS cluster that's associated with it. Then, launch your container instances into that Amazon ECS cluster. For more information, see [Launching an Amazon ECS container instance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Batch doesn't automatically upgrade the AMIs in a compute environment after it's created. For example, it also doesn't update the AMIs in your compute environment when a newer version of the Amazon ECS optimized AMI is available. You're responsible for the management of the guest operating system. This includes any updates and security patches. You're also responsible for any additional application software or utilities that you install on the compute resources. There are two ways to use a new AMI for your Batch jobs. The original method is to complete these steps:
     * + Create a new compute environment with the new AMI.
     * + Add the compute environment to an existing job queue.
     * + Remove the earlier compute environment from your job queue.
     * + Delete the earlier compute environment.
     * In April 2022, Batch added enhanced support for updating compute environments. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html). To use the enhanced updating of compute environments to update AMIs, follow these rules:
     * + Either don't set the service role (`serviceRole`) parameter or set it to the **AWSBatchServiceRole** service-linked role.
     * + Set the allocation strategy (`allocationStrategy`) parameter to `BEST_FIT_PROGRESSIVE` or `SPOT_CAPACITY_OPTIMIZED`.
     * + Set the update to latest image version (`updateToLatestImageVersion`) parameter to `true`.
     * + Don't specify an AMI ID in `imageId`, `imageIdOverride` (in `ec2Configuration`[](https://docs.aws.amazon.com/batch/latest/APIReference/API_Ec2Configuration.html)), or in the launch template (`launchTemplate`). In that case, Batch selects the latest Amazon ECS optimized AMI that's supported by Batch at the time the infrastructure update is initiated. Alternatively, you can specify the AMI ID in the `imageId` or `imageIdOverride` parameters, or the launch template identified by the `LaunchTemplate` properties. Changing any of these properties starts an infrastructure update. If the AMI ID is specified in the launch template, it can't be replaced by specifying an AMI ID in either the `imageId` or `imageIdOverride` parameters. It can only be replaced by specifying a different launch template, or if the launch template version is set to `$Default` or `$Latest`, by setting either a new default version for the launch template (if `$Default`) or by adding a new version to the launch template (if `$Latest`).
     * If these rules are followed, any update that starts an infrastructure update causes the AMI ID to be re-selected. If the `version` setting in the launch template (`launchTemplate`) is set to `$Latest` or `$Default`, the latest or default version of the launch template is evaluated up at the time of the infrastructure update, even if the `launchTemplate` wasn't updated.
     */
    override suspend fun createComputeEnvironment(input: CreateComputeEnvironmentRequest): CreateComputeEnvironmentResponse {
        val op = SdkHttpOperation.build<CreateComputeEnvironmentRequest, CreateComputeEnvironmentResponse> {
            serializer = CreateComputeEnvironmentOperationSerializer()
            deserializer = CreateComputeEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateComputeEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Batch job queue. When you create a job queue, you associate one or more compute environments to the queue and assign an order of preference for the compute environments.
     *
     * You also set a priority to the job queue that determines the order that the Batch scheduler places jobs onto its associated compute environments. For example, if a compute environment is associated with more than one job queue, the job queue with a higher priority is given preference for scheduling jobs to that compute environment.
     */
    override suspend fun createJobQueue(input: CreateJobQueueRequest): CreateJobQueueResponse {
        val op = SdkHttpOperation.build<CreateJobQueueRequest, CreateJobQueueResponse> {
            serializer = CreateJobQueueOperationSerializer()
            deserializer = CreateJobQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateJobQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Batch scheduling policy.
     */
    override suspend fun createSchedulingPolicy(input: CreateSchedulingPolicyRequest): CreateSchedulingPolicyResponse {
        val op = SdkHttpOperation.build<CreateSchedulingPolicyRequest, CreateSchedulingPolicyResponse> {
            serializer = CreateSchedulingPolicyOperationSerializer()
            deserializer = CreateSchedulingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSchedulingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Batch compute environment.
     *
     * Before you can delete a compute environment, you must set its state to `DISABLED` with the UpdateComputeEnvironment API operation and disassociate it from any job queues with the UpdateJobQueue API operation. Compute environments that use Fargate resources must terminate all active jobs on that compute environment before deleting the compute environment. If this isn't done, the compute environment enters an invalid state.
     */
    override suspend fun deleteComputeEnvironment(input: DeleteComputeEnvironmentRequest): DeleteComputeEnvironmentResponse {
        val op = SdkHttpOperation.build<DeleteComputeEnvironmentRequest, DeleteComputeEnvironmentResponse> {
            serializer = DeleteComputeEnvironmentOperationSerializer()
            deserializer = DeleteComputeEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteComputeEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified job queue. You must first disable submissions for a queue with the UpdateJobQueue operation. All jobs in the queue are eventually terminated when you delete a job queue. The jobs are terminated at a rate of about 16 jobs each second.
     *
     * It's not necessary to disassociate compute environments from a queue before submitting a `DeleteJobQueue` request.
     */
    override suspend fun deleteJobQueue(input: DeleteJobQueueRequest): DeleteJobQueueResponse {
        val op = SdkHttpOperation.build<DeleteJobQueueRequest, DeleteJobQueueResponse> {
            serializer = DeleteJobQueueOperationSerializer()
            deserializer = DeleteJobQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteJobQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified scheduling policy.
     *
     * You can't delete a scheduling policy that's used in any job queues.
     */
    override suspend fun deleteSchedulingPolicy(input: DeleteSchedulingPolicyRequest): DeleteSchedulingPolicyResponse {
        val op = SdkHttpOperation.build<DeleteSchedulingPolicyRequest, DeleteSchedulingPolicyResponse> {
            serializer = DeleteSchedulingPolicyOperationSerializer()
            deserializer = DeleteSchedulingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSchedulingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an Batch job definition. Job definitions are permanently deleted after 180 days.
     */
    override suspend fun deregisterJobDefinition(input: DeregisterJobDefinitionRequest): DeregisterJobDefinitionResponse {
        val op = SdkHttpOperation.build<DeregisterJobDefinitionRequest, DeregisterJobDefinitionResponse> {
            serializer = DeregisterJobDefinitionOperationSerializer()
            deserializer = DeregisterJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your compute environments.
     *
     * If you're using an unmanaged compute environment, you can use the `DescribeComputeEnvironment` operation to determine the `ecsClusterArn` that you launch your Amazon ECS container instances into.
     */
    override suspend fun describeComputeEnvironments(input: DescribeComputeEnvironmentsRequest): DescribeComputeEnvironmentsResponse {
        val op = SdkHttpOperation.build<DescribeComputeEnvironmentsRequest, DescribeComputeEnvironmentsResponse> {
            serializer = DescribeComputeEnvironmentsOperationSerializer()
            deserializer = DescribeComputeEnvironmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeComputeEnvironments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a list of job definitions. You can specify a `status` (such as `ACTIVE`) to only return job definitions that match that status.
     */
    override suspend fun describeJobDefinitions(input: DescribeJobDefinitionsRequest): DescribeJobDefinitionsResponse {
        val op = SdkHttpOperation.build<DescribeJobDefinitionsRequest, DescribeJobDefinitionsResponse> {
            serializer = DescribeJobDefinitionsOperationSerializer()
            deserializer = DescribeJobDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJobDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your job queues.
     */
    override suspend fun describeJobQueues(input: DescribeJobQueuesRequest): DescribeJobQueuesResponse {
        val op = SdkHttpOperation.build<DescribeJobQueuesRequest, DescribeJobQueuesResponse> {
            serializer = DescribeJobQueuesOperationSerializer()
            deserializer = DescribeJobQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJobQueues"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a list of Batch jobs.
     */
    override suspend fun describeJobs(input: DescribeJobsRequest): DescribeJobsResponse {
        val op = SdkHttpOperation.build<DescribeJobsRequest, DescribeJobsResponse> {
            serializer = DescribeJobsOperationSerializer()
            deserializer = DescribeJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your scheduling policies.
     */
    override suspend fun describeSchedulingPolicies(input: DescribeSchedulingPoliciesRequest): DescribeSchedulingPoliciesResponse {
        val op = SdkHttpOperation.build<DescribeSchedulingPoliciesRequest, DescribeSchedulingPoliciesResponse> {
            serializer = DescribeSchedulingPoliciesOperationSerializer()
            deserializer = DescribeSchedulingPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSchedulingPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Batch jobs.
     *
     * You must specify only one of the following items:
     * + A job queue ID to return a list of jobs in that job queue
     * + A multi-node parallel job ID to return a list of nodes for that job
     * + An array job ID to return a list of the children for that job
     *
     * You can filter the results by job status with the `jobStatus` parameter. If you don't specify a status, only `RUNNING` jobs are returned.
     */
    override suspend fun listJobs(input: ListJobsRequest): ListJobsResponse {
        val op = SdkHttpOperation.build<ListJobsRequest, ListJobsResponse> {
            serializer = ListJobsOperationSerializer()
            deserializer = ListJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Batch scheduling policies.
     */
    override suspend fun listSchedulingPolicies(input: ListSchedulingPoliciesRequest): ListSchedulingPoliciesResponse {
        val op = SdkHttpOperation.build<ListSchedulingPoliciesRequest, ListSchedulingPoliciesResponse> {
            serializer = ListSchedulingPoliciesOperationSerializer()
            deserializer = ListSchedulingPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSchedulingPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for an Batch resource. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs aren't supported.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Batch job definition.
     */
    override suspend fun registerJobDefinition(input: RegisterJobDefinitionRequest): RegisterJobDefinitionResponse {
        val op = SdkHttpOperation.build<RegisterJobDefinitionRequest, RegisterJobDefinitionResponse> {
            serializer = RegisterJobDefinitionOperationSerializer()
            deserializer = RegisterJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Submits an Batch job from a job definition. Parameters that are specified during SubmitJob override parameters defined in the job definition. vCPU and memory requirements that are specified in the `resourceRequirements` objects in the job definition are the exception. They can't be overridden this way using the `memory` and `vcpus` parameters. Rather, you must specify updates to job definition parameters in a `resourceRequirements` object that's included in the `containerOverrides` parameter.
     *
     * Job queues with a scheduling policy are limited to 500 active fair share identifiers at a time.
     *
     * Jobs that run on Fargate resources can't be guaranteed to run for more than 14 days. This is because, after 14 days, Fargate resources might become unavailable and job might be terminated.
     */
    override suspend fun submitJob(input: SubmitJobRequest): SubmitJobResponse {
        val op = SdkHttpOperation.build<SubmitJobRequest, SubmitJobResponse> {
            serializer = SubmitJobOperationSerializer()
            deserializer = SubmitJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SubmitJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags that are associated with that resource are deleted as well. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs aren't supported.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Terminates a job in a job queue. Jobs that are in the `STARTING` or `RUNNING` state are terminated, which causes them to transition to `FAILED`. Jobs that have not progressed to the `STARTING` state are cancelled.
     */
    override suspend fun terminateJob(input: TerminateJobRequest): TerminateJobResponse {
        val op = SdkHttpOperation.build<TerminateJobRequest, TerminateJobResponse> {
            serializer = TerminateJobOperationSerializer()
            deserializer = TerminateJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TerminateJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes specified tags from an Batch resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Batch compute environment.
     */
    override suspend fun updateComputeEnvironment(input: UpdateComputeEnvironmentRequest): UpdateComputeEnvironmentResponse {
        val op = SdkHttpOperation.build<UpdateComputeEnvironmentRequest, UpdateComputeEnvironmentResponse> {
            serializer = UpdateComputeEnvironmentOperationSerializer()
            deserializer = UpdateComputeEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComputeEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a job queue.
     */
    override suspend fun updateJobQueue(input: UpdateJobQueueRequest): UpdateJobQueueResponse {
        val op = SdkHttpOperation.build<UpdateJobQueueRequest, UpdateJobQueueResponse> {
            serializer = UpdateJobQueueOperationSerializer()
            deserializer = UpdateJobQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateJobQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a scheduling policy.
     */
    override suspend fun updateSchedulingPolicy(input: UpdateSchedulingPolicyRequest): UpdateSchedulingPolicyResponse {
        val op = SdkHttpOperation.build<UpdateSchedulingPolicyRequest, UpdateSchedulingPolicyResponse> {
            serializer = UpdateSchedulingPolicyOperationSerializer()
            deserializer = UpdateSchedulingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSchedulingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "batch"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "batch")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
