// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents the details of a container that's part of a job attempt.
 */
public class AttemptContainerDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
     */
    public val containerInstanceArn: kotlin.String? = builder.containerInstanceArn
    /**
     * The exit code for the job attempt. A non-zero exit code is considered failed.
     */
    public val exitCode: kotlin.Int? = builder.exitCode
    /**
     * The name of the CloudWatch Logs log stream that's associated with the container. The log group for Batch jobs is `/aws/batch/job`. Each container attempt receives a log stream name when they reach the `RUNNING` status.
     */
    public val logStreamName: kotlin.String? = builder.logStreamName
    /**
     * The network interfaces that are associated with the job attempt.
     */
    public val networkInterfaces: List<NetworkInterface>? = builder.networkInterfaces
    /**
     * A short (255 max characters) human-readable string to provide additional details for a running or stopped container.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with the job attempt. Each container attempt receives a task ARN when they reach the `STARTING` status.
     */
    public val taskArn: kotlin.String? = builder.taskArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.AttemptContainerDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttemptContainerDetail(")
        append("containerInstanceArn=$containerInstanceArn,")
        append("exitCode=$exitCode,")
        append("logStreamName=$logStreamName,")
        append("networkInterfaces=$networkInterfaces,")
        append("reason=$reason,")
        append("taskArn=$taskArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerInstanceArn?.hashCode() ?: 0
        result = 31 * result + (exitCode ?: 0)
        result = 31 * result + (logStreamName?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttemptContainerDetail

        if (containerInstanceArn != other.containerInstanceArn) return false
        if (exitCode != other.exitCode) return false
        if (logStreamName != other.logStreamName) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (reason != other.reason) return false
        if (taskArn != other.taskArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.AttemptContainerDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
         */
        public var containerInstanceArn: kotlin.String? = null
        /**
         * The exit code for the job attempt. A non-zero exit code is considered failed.
         */
        public var exitCode: kotlin.Int? = null
        /**
         * The name of the CloudWatch Logs log stream that's associated with the container. The log group for Batch jobs is `/aws/batch/job`. Each container attempt receives a log stream name when they reach the `RUNNING` status.
         */
        public var logStreamName: kotlin.String? = null
        /**
         * The network interfaces that are associated with the job attempt.
         */
        public var networkInterfaces: List<NetworkInterface>? = null
        /**
         * A short (255 max characters) human-readable string to provide additional details for a running or stopped container.
         */
        public var reason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with the job attempt. Each container attempt receives a task ARN when they reach the `STARTING` status.
         */
        public var taskArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.AttemptContainerDetail) : this() {
            this.containerInstanceArn = x.containerInstanceArn
            this.exitCode = x.exitCode
            this.logStreamName = x.logStreamName
            this.networkInterfaces = x.networkInterfaces
            this.reason = x.reason
            this.taskArn = x.taskArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.AttemptContainerDetail = AttemptContainerDetail(this)
    }
}
