// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents an Batch compute environment.
 */
public class ComputeEnvironmentDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the compute environment.
     */
    public val computeEnvironmentArn: kotlin.String? = builder.computeEnvironmentArn
    /**
     * The name of the compute environment. It can be up to 128 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public val computeEnvironmentName: kotlin.String? = builder.computeEnvironmentName
    /**
     * The compute resources defined for the compute environment. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     */
    public val computeResources: aws.sdk.kotlin.services.batch.model.ComputeResource? = builder.computeResources
    /**
     * The orchestration type of the compute environment. The valid values are `ECS` (default) or `EKS`.
     */
    public val containerOrchestrationType: aws.sdk.kotlin.services.batch.model.OrchestrationType? = builder.containerOrchestrationType
    /**
     * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster that the compute environment uses.
     */
    public val ecsClusterArn: kotlin.String? = builder.ecsClusterArn
    /**
     * The configuration for the Amazon EKS cluster that supports the Batch compute environment. Only specify this parameter if the `containerOrchestrationType` is `EKS`.
     */
    public val eksConfiguration: aws.sdk.kotlin.services.batch.model.EksConfiguration? = builder.eksConfiguration
    /**
     * The service role that's associated with the compute environment that allows Batch to make calls to Amazon Web Services API operations on your behalf. For more information, see [Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *Batch User Guide*.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The state of the compute environment. The valid values are `ENABLED` or `DISABLED`.
     *
     * If the state is `ENABLED`, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically based on the job queue demand.
     *
     * If the state is `DISABLED`, then the Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out. However, they scale in to `minvCpus` value after instances become idle.
     */
    public val state: aws.sdk.kotlin.services.batch.model.CeState? = builder.state
    /**
     * The current status of the compute environment (for example, `CREATING` or `VALID`).
     */
    public val status: aws.sdk.kotlin.services.batch.model.CeStatus? = builder.status
    /**
     * A short, human-readable string to provide additional details for the current status of the compute environment.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The tags applied to the compute environment.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the compute environment: `MANAGED` or `UNMANAGED`. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     */
    public val type: aws.sdk.kotlin.services.batch.model.CeType? = builder.type
    /**
     * The maximum number of VCPUs expected to be used for an unmanaged compute environment.
     */
    public val unmanagedvCpus: kotlin.Int? = builder.unmanagedvCpus
    /**
     * Specifies the infrastructure update policy for the compute environment. For more information about infrastructure updates, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     */
    public val updatePolicy: aws.sdk.kotlin.services.batch.model.UpdatePolicy? = builder.updatePolicy
    /**
     * Unique identifier for the compute environment.
     */
    public val uuid: kotlin.String? = builder.uuid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ComputeEnvironmentDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeEnvironmentDetail(")
        append("computeEnvironmentArn=$computeEnvironmentArn,")
        append("computeEnvironmentName=$computeEnvironmentName,")
        append("computeResources=$computeResources,")
        append("containerOrchestrationType=$containerOrchestrationType,")
        append("ecsClusterArn=$ecsClusterArn,")
        append("eksConfiguration=$eksConfiguration,")
        append("serviceRole=$serviceRole,")
        append("state=$state,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags,")
        append("type=$type,")
        append("unmanagedvCpus=$unmanagedvCpus,")
        append("updatePolicy=$updatePolicy,")
        append("uuid=$uuid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironmentArn?.hashCode() ?: 0
        result = 31 * result + (computeEnvironmentName?.hashCode() ?: 0)
        result = 31 * result + (computeResources?.hashCode() ?: 0)
        result = 31 * result + (containerOrchestrationType?.hashCode() ?: 0)
        result = 31 * result + (ecsClusterArn?.hashCode() ?: 0)
        result = 31 * result + (eksConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (unmanagedvCpus ?: 0)
        result = 31 * result + (updatePolicy?.hashCode() ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeEnvironmentDetail

        if (computeEnvironmentArn != other.computeEnvironmentArn) return false
        if (computeEnvironmentName != other.computeEnvironmentName) return false
        if (computeResources != other.computeResources) return false
        if (containerOrchestrationType != other.containerOrchestrationType) return false
        if (ecsClusterArn != other.ecsClusterArn) return false
        if (eksConfiguration != other.eksConfiguration) return false
        if (serviceRole != other.serviceRole) return false
        if (state != other.state) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (unmanagedvCpus != other.unmanagedvCpus) return false
        if (updatePolicy != other.updatePolicy) return false
        if (uuid != other.uuid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ComputeEnvironmentDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the compute environment.
         */
        public var computeEnvironmentArn: kotlin.String? = null
        /**
         * The name of the compute environment. It can be up to 128 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         */
        public var computeEnvironmentName: kotlin.String? = null
        /**
         * The compute resources defined for the compute environment. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         */
        public var computeResources: aws.sdk.kotlin.services.batch.model.ComputeResource? = null
        /**
         * The orchestration type of the compute environment. The valid values are `ECS` (default) or `EKS`.
         */
        public var containerOrchestrationType: aws.sdk.kotlin.services.batch.model.OrchestrationType? = null
        /**
         * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster that the compute environment uses.
         */
        public var ecsClusterArn: kotlin.String? = null
        /**
         * The configuration for the Amazon EKS cluster that supports the Batch compute environment. Only specify this parameter if the `containerOrchestrationType` is `EKS`.
         */
        public var eksConfiguration: aws.sdk.kotlin.services.batch.model.EksConfiguration? = null
        /**
         * The service role that's associated with the compute environment that allows Batch to make calls to Amazon Web Services API operations on your behalf. For more information, see [Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *Batch User Guide*.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The state of the compute environment. The valid values are `ENABLED` or `DISABLED`.
         *
         * If the state is `ENABLED`, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically based on the job queue demand.
         *
         * If the state is `DISABLED`, then the Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out. However, they scale in to `minvCpus` value after instances become idle.
         */
        public var state: aws.sdk.kotlin.services.batch.model.CeState? = null
        /**
         * The current status of the compute environment (for example, `CREATING` or `VALID`).
         */
        public var status: aws.sdk.kotlin.services.batch.model.CeStatus? = null
        /**
         * A short, human-readable string to provide additional details for the current status of the compute environment.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The tags applied to the compute environment.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the compute environment: `MANAGED` or `UNMANAGED`. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         */
        public var type: aws.sdk.kotlin.services.batch.model.CeType? = null
        /**
         * The maximum number of VCPUs expected to be used for an unmanaged compute environment.
         */
        public var unmanagedvCpus: kotlin.Int? = null
        /**
         * Specifies the infrastructure update policy for the compute environment. For more information about infrastructure updates, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         */
        public var updatePolicy: aws.sdk.kotlin.services.batch.model.UpdatePolicy? = null
        /**
         * Unique identifier for the compute environment.
         */
        public var uuid: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ComputeEnvironmentDetail) : this() {
            this.computeEnvironmentArn = x.computeEnvironmentArn
            this.computeEnvironmentName = x.computeEnvironmentName
            this.computeResources = x.computeResources
            this.containerOrchestrationType = x.containerOrchestrationType
            this.ecsClusterArn = x.ecsClusterArn
            this.eksConfiguration = x.eksConfiguration
            this.serviceRole = x.serviceRole
            this.state = x.state
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
            this.type = x.type
            this.unmanagedvCpus = x.unmanagedvCpus
            this.updatePolicy = x.updatePolicy
            this.uuid = x.uuid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ComputeEnvironmentDetail = ComputeEnvironmentDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ComputeResource] inside the given [block]
         */
        public fun computeResources(block: aws.sdk.kotlin.services.batch.model.ComputeResource.Builder.() -> kotlin.Unit) {
            this.computeResources = aws.sdk.kotlin.services.batch.model.ComputeResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksConfiguration] inside the given [block]
         */
        public fun eksConfiguration(block: aws.sdk.kotlin.services.batch.model.EksConfiguration.Builder.() -> kotlin.Unit) {
            this.eksConfiguration = aws.sdk.kotlin.services.batch.model.EksConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.UpdatePolicy] inside the given [block]
         */
        public fun updatePolicy(block: aws.sdk.kotlin.services.batch.model.UpdatePolicy.Builder.() -> kotlin.Unit) {
            this.updatePolicy = aws.sdk.kotlin.services.batch.model.UpdatePolicy.invoke(block)
        }
    }
}
