// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents the details of a container that's part of a job.
 */
public class ContainerDetail private constructor(builder: Builder) {
    /**
     * The command that's passed to the container.
     */
    public val command: List<String>? = builder.command
    /**
     * The Amazon Resource Name (ARN) of the container instance that the container is running on.
     */
    public val containerInstanceArn: kotlin.String? = builder.containerInstanceArn
    /**
     * The environment variables to pass to a container.
     *
     * Environment variables cannot start with "`AWS_BATCH`". This naming convention is reserved for variables that Batch sets.
     */
    public val environment: List<KeyValuePair>? = builder.environment
    /**
     * The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see [Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *Batch User Guide*.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The exit code to return upon completion.
     */
    public val exitCode: kotlin.Int? = builder.exitCode
    /**
     * The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
     */
    public val fargatePlatformConfiguration: aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration? = builder.fargatePlatformConfiguration
    /**
     * The image used to start the container.
     */
    public val image: kotlin.String? = builder.image
    /**
     * The instance type of the underlying host infrastructure of a multi-node parallel job.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) that's associated with the job when run.
     */
    public val jobRoleArn: kotlin.String? = builder.jobRoleArn
    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     */
    public val linuxParameters: aws.sdk.kotlin.services.batch.model.LinuxParameters? = builder.linuxParameters
    /**
     * The log configuration specification for the container.
     *
     * This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.docker.com/engine/reference/run/). By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance. Or, alternatively, it must be configured on a different log server for remote logging options. For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
     *
     * Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the LogConfiguration data type). Additional log drivers might be available in future releases of the Amazon ECS container agent.
     *
     * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
     *
     * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val logConfiguration: aws.sdk.kotlin.services.batch.model.LogConfiguration? = builder.logConfiguration
    /**
     * The name of the Amazon CloudWatch Logs log stream that's associated with the container. The log group for Batch jobs is `/aws/batch/job`. Each container attempt receives a log stream name when they reach the `RUNNING` status.
     */
    public val logStreamName: kotlin.String? = builder.logStreamName
    /**
     * For jobs running on EC2 resources that didn't specify memory requirements using `resourceRequirements`, the number of MiB of memory reserved for the job. For other jobs, including all run on Fargate resources, see `resourceRequirements`.
     */
    public val memory: kotlin.Int? = builder.memory
    /**
     * The mount points for data volumes in your container.
     */
    public val mountPoints: List<MountPoint>? = builder.mountPoints
    /**
     * The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.batch.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The network interfaces that are associated with the job.
     */
    public val networkInterfaces: List<NetworkInterface>? = builder.networkInterfaces
    /**
     * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). The default value is `false`.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as `false`.
     */
    public val privileged: kotlin.Boolean? = builder.privileged
    /**
     * When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run`[](https://docs.docker.com/engine/reference/commandline/run/).
     */
    public val readonlyRootFilesystem: kotlin.Boolean? = builder.readonlyRootFilesystem
    /**
     * A short (255 max characters) human-readable string to provide additional details for a running or stopped container.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The type and amount of resources to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
     */
    public val resourceRequirements: List<ResourceRequirement>? = builder.resourceRequirements
    /**
     * The secrets to pass to the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *Batch User Guide*.
     */
    public val secrets: List<Secret>? = builder.secrets
    /**
     * The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with the container job. Each container attempt receives a task ARN when they reach the `STARTING` status.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * A list of `ulimit` values to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources.
     */
    public val ulimits: List<Ulimit>? = builder.ulimits
    /**
     * The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.docker.com/engine/reference/run/).
     */
    public val user: kotlin.String? = builder.user
    /**
     * The number of vCPUs reserved for the container. For jobs that run on EC2 resources, you can specify the vCPU requirement for the job using `resourceRequirements`, but you can't specify the vCPU requirements in both the `vcpus` and `resourceRequirements` object. This parameter maps to `CpuShares` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.docker.com/engine/reference/run/). Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one vCPU. This is required but can be specified in several places. It must be specified for each node at least once.
     *
     * This parameter isn't applicable to jobs that run on Fargate resources. For jobs that run on Fargate resources, you must specify the vCPU requirement for the job using `resourceRequirements`.
     */
    public val vcpus: kotlin.Int? = builder.vcpus
    /**
     * A list of volumes that are associated with the job.
     */
    public val volumes: List<Volume>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ContainerDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDetail(")
        append("command=$command,")
        append("containerInstanceArn=$containerInstanceArn,")
        append("environment=$environment,")
        append("executionRoleArn=$executionRoleArn,")
        append("exitCode=$exitCode,")
        append("fargatePlatformConfiguration=$fargatePlatformConfiguration,")
        append("image=$image,")
        append("instanceType=$instanceType,")
        append("jobRoleArn=$jobRoleArn,")
        append("linuxParameters=$linuxParameters,")
        append("logConfiguration=$logConfiguration,")
        append("logStreamName=$logStreamName,")
        append("memory=$memory,")
        append("mountPoints=$mountPoints,")
        append("networkConfiguration=$networkConfiguration,")
        append("networkInterfaces=$networkInterfaces,")
        append("privileged=$privileged,")
        append("readonlyRootFilesystem=$readonlyRootFilesystem,")
        append("reason=$reason,")
        append("resourceRequirements=$resourceRequirements,")
        append("secrets=$secrets,")
        append("taskArn=$taskArn,")
        append("ulimits=$ulimits,")
        append("user=$user,")
        append("vcpus=$vcpus,")
        append("volumes=$volumes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (containerInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (exitCode ?: 0)
        result = 31 * result + (fargatePlatformConfiguration?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (jobRoleArn?.hashCode() ?: 0)
        result = 31 * result + (linuxParameters?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (logStreamName?.hashCode() ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (mountPoints?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (privileged?.hashCode() ?: 0)
        result = 31 * result + (readonlyRootFilesystem?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (resourceRequirements?.hashCode() ?: 0)
        result = 31 * result + (secrets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (ulimits?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        result = 31 * result + (vcpus ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDetail

        if (command != other.command) return false
        if (containerInstanceArn != other.containerInstanceArn) return false
        if (environment != other.environment) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (exitCode != other.exitCode) return false
        if (fargatePlatformConfiguration != other.fargatePlatformConfiguration) return false
        if (image != other.image) return false
        if (instanceType != other.instanceType) return false
        if (jobRoleArn != other.jobRoleArn) return false
        if (linuxParameters != other.linuxParameters) return false
        if (logConfiguration != other.logConfiguration) return false
        if (logStreamName != other.logStreamName) return false
        if (memory != other.memory) return false
        if (mountPoints != other.mountPoints) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (privileged != other.privileged) return false
        if (readonlyRootFilesystem != other.readonlyRootFilesystem) return false
        if (reason != other.reason) return false
        if (resourceRequirements != other.resourceRequirements) return false
        if (secrets != other.secrets) return false
        if (taskArn != other.taskArn) return false
        if (ulimits != other.ulimits) return false
        if (user != other.user) return false
        if (vcpus != other.vcpus) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ContainerDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The command that's passed to the container.
         */
        public var command: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the container instance that the container is running on.
         */
        public var containerInstanceArn: kotlin.String? = null
        /**
         * The environment variables to pass to a container.
         *
         * Environment variables cannot start with "`AWS_BATCH`". This naming convention is reserved for variables that Batch sets.
         */
        public var environment: List<KeyValuePair>? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see [Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *Batch User Guide*.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The exit code to return upon completion.
         */
        public var exitCode: kotlin.Int? = null
        /**
         * The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
         */
        public var fargatePlatformConfiguration: aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration? = null
        /**
         * The image used to start the container.
         */
        public var image: kotlin.String? = null
        /**
         * The instance type of the underlying host infrastructure of a multi-node parallel job.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that's associated with the job when run.
         */
        public var jobRoleArn: kotlin.String? = null
        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         */
        public var linuxParameters: aws.sdk.kotlin.services.batch.model.LinuxParameters? = null
        /**
         * The log configuration specification for the container.
         *
         * This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.docker.com/engine/reference/run/). By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance. Or, alternatively, it must be configured on a different log server for remote logging options. For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
         *
         * Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the LogConfiguration data type). Additional log drivers might be available in future releases of the Amazon ECS container agent.
         *
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
         *
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var logConfiguration: aws.sdk.kotlin.services.batch.model.LogConfiguration? = null
        /**
         * The name of the Amazon CloudWatch Logs log stream that's associated with the container. The log group for Batch jobs is `/aws/batch/job`. Each container attempt receives a log stream name when they reach the `RUNNING` status.
         */
        public var logStreamName: kotlin.String? = null
        /**
         * For jobs running on EC2 resources that didn't specify memory requirements using `resourceRequirements`, the number of MiB of memory reserved for the job. For other jobs, including all run on Fargate resources, see `resourceRequirements`.
         */
        public var memory: kotlin.Int? = null
        /**
         * The mount points for data volumes in your container.
         */
        public var mountPoints: List<MountPoint>? = null
        /**
         * The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.batch.model.NetworkConfiguration? = null
        /**
         * The network interfaces that are associated with the job.
         */
        public var networkInterfaces: List<NetworkInterface>? = null
        /**
         * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). The default value is `false`.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as `false`.
         */
        public var privileged: kotlin.Boolean? = null
        /**
         * When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run`[](https://docs.docker.com/engine/reference/commandline/run/).
         */
        public var readonlyRootFilesystem: kotlin.Boolean? = null
        /**
         * A short (255 max characters) human-readable string to provide additional details for a running or stopped container.
         */
        public var reason: kotlin.String? = null
        /**
         * The type and amount of resources to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
         */
        public var resourceRequirements: List<ResourceRequirement>? = null
        /**
         * The secrets to pass to the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *Batch User Guide*.
         */
        public var secrets: List<Secret>? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with the container job. Each container attempt receives a task ARN when they reach the `STARTING` status.
         */
        public var taskArn: kotlin.String? = null
        /**
         * A list of `ulimit` values to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources.
         */
        public var ulimits: List<Ulimit>? = null
        /**
         * The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.docker.com/engine/reference/run/).
         */
        public var user: kotlin.String? = null
        /**
         * The number of vCPUs reserved for the container. For jobs that run on EC2 resources, you can specify the vCPU requirement for the job using `resourceRequirements`, but you can't specify the vCPU requirements in both the `vcpus` and `resourceRequirements` object. This parameter maps to `CpuShares` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.docker.com/engine/reference/run/). Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one vCPU. This is required but can be specified in several places. It must be specified for each node at least once.
         *
         * This parameter isn't applicable to jobs that run on Fargate resources. For jobs that run on Fargate resources, you must specify the vCPU requirement for the job using `resourceRequirements`.
         */
        public var vcpus: kotlin.Int? = null
        /**
         * A list of volumes that are associated with the job.
         */
        public var volumes: List<Volume>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ContainerDetail) : this() {
            this.command = x.command
            this.containerInstanceArn = x.containerInstanceArn
            this.environment = x.environment
            this.executionRoleArn = x.executionRoleArn
            this.exitCode = x.exitCode
            this.fargatePlatformConfiguration = x.fargatePlatformConfiguration
            this.image = x.image
            this.instanceType = x.instanceType
            this.jobRoleArn = x.jobRoleArn
            this.linuxParameters = x.linuxParameters
            this.logConfiguration = x.logConfiguration
            this.logStreamName = x.logStreamName
            this.memory = x.memory
            this.mountPoints = x.mountPoints
            this.networkConfiguration = x.networkConfiguration
            this.networkInterfaces = x.networkInterfaces
            this.privileged = x.privileged
            this.readonlyRootFilesystem = x.readonlyRootFilesystem
            this.reason = x.reason
            this.resourceRequirements = x.resourceRequirements
            this.secrets = x.secrets
            this.taskArn = x.taskArn
            this.ulimits = x.ulimits
            this.user = x.user
            this.vcpus = x.vcpus
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ContainerDetail = ContainerDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration] inside the given [block]
         */
        public fun fargatePlatformConfiguration(block: aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration.Builder.() -> kotlin.Unit) {
            this.fargatePlatformConfiguration = aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.LinuxParameters] inside the given [block]
         */
        public fun linuxParameters(block: aws.sdk.kotlin.services.batch.model.LinuxParameters.Builder.() -> kotlin.Unit) {
            this.linuxParameters = aws.sdk.kotlin.services.batch.model.LinuxParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.LogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.batch.model.LogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.batch.model.LogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.batch.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.batch.model.NetworkConfiguration.invoke(block)
        }
    }
}
