// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `CreateComputeEnvironment`.
 */
public class CreateComputeEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The name for your compute environment. It can be up to 128 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public val computeEnvironmentName: kotlin.String? = builder.computeEnvironmentName
    /**
     * Details about the compute resources managed by the compute environment. This parameter is required for managed compute environments. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     */
    public val computeResources: aws.sdk.kotlin.services.batch.model.ComputeResource? = builder.computeResources
    /**
     * The details for the Amazon EKS cluster that supports the compute environment.
     */
    public val eksConfiguration: aws.sdk.kotlin.services.batch.model.EksConfiguration? = builder.eksConfiguration
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services services on your behalf. For more information, see [Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *Batch User Guide*.
     *
     * If your account already created the Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the Batch service-linked role in your account.
     *
     * If your specified role has a path other than `/`, then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name `bar` has a path of `/foo/`, specify `/foo/bar` as the role name. For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide*.
     *
     * Depending on how you created your Batch service role, its ARN might contain the `service-role` path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use the `service-role` path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
     *
     * If the state is `ENABLED`, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
     *
     * If the state is `DISABLED`, then the Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out. However, they scale in to `minvCpus` value after instances become idle.
     */
    public val state: aws.sdk.kotlin.services.batch.model.CeState? = builder.state
    /**
     * The tags that you apply to the compute environment to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in *Amazon Web Services General Reference*.
     *
     * These tags can be updated or removed using the [TagResource](https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html) and [UntagResource](https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html) API operations. These tags don't propagate to the underlying compute resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the compute environment: `MANAGED` or `UNMANAGED`. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     */
    public val type: aws.sdk.kotlin.services.batch.model.CeType? = builder.type
    /**
     * The maximum number of vCPUs for an unmanaged compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
     *
     * This parameter is only supported when the `type` parameter is set to `UNMANAGED`.
     */
    public val unmanagedvCpus: kotlin.Int? = builder.unmanagedvCpus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.CreateComputeEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComputeEnvironmentRequest(")
        append("computeEnvironmentName=$computeEnvironmentName,")
        append("computeResources=$computeResources,")
        append("eksConfiguration=$eksConfiguration,")
        append("serviceRole=$serviceRole,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("unmanagedvCpus=$unmanagedvCpus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironmentName?.hashCode() ?: 0
        result = 31 * result + (computeResources?.hashCode() ?: 0)
        result = 31 * result + (eksConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (unmanagedvCpus ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateComputeEnvironmentRequest

        if (computeEnvironmentName != other.computeEnvironmentName) return false
        if (computeResources != other.computeResources) return false
        if (eksConfiguration != other.eksConfiguration) return false
        if (serviceRole != other.serviceRole) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (unmanagedvCpus != other.unmanagedvCpus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.CreateComputeEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name for your compute environment. It can be up to 128 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         */
        public var computeEnvironmentName: kotlin.String? = null
        /**
         * Details about the compute resources managed by the compute environment. This parameter is required for managed compute environments. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         */
        public var computeResources: aws.sdk.kotlin.services.batch.model.ComputeResource? = null
        /**
         * The details for the Amazon EKS cluster that supports the compute environment.
         */
        public var eksConfiguration: aws.sdk.kotlin.services.batch.model.EksConfiguration? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services services on your behalf. For more information, see [Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *Batch User Guide*.
         *
         * If your account already created the Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the Batch service-linked role in your account.
         *
         * If your specified role has a path other than `/`, then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name `bar` has a path of `/foo/`, specify `/foo/bar` as the role name. For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide*.
         *
         * Depending on how you created your Batch service role, its ARN might contain the `service-role` path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use the `service-role` path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
         *
         * If the state is `ENABLED`, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *
         * If the state is `DISABLED`, then the Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out. However, they scale in to `minvCpus` value after instances become idle.
         */
        public var state: aws.sdk.kotlin.services.batch.model.CeState? = null
        /**
         * The tags that you apply to the compute environment to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in *Amazon Web Services General Reference*.
         *
         * These tags can be updated or removed using the [TagResource](https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html) and [UntagResource](https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html) API operations. These tags don't propagate to the underlying compute resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the compute environment: `MANAGED` or `UNMANAGED`. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         */
        public var type: aws.sdk.kotlin.services.batch.model.CeType? = null
        /**
         * The maximum number of vCPUs for an unmanaged compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
         *
         * This parameter is only supported when the `type` parameter is set to `UNMANAGED`.
         */
        public var unmanagedvCpus: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.CreateComputeEnvironmentRequest) : this() {
            this.computeEnvironmentName = x.computeEnvironmentName
            this.computeResources = x.computeResources
            this.eksConfiguration = x.eksConfiguration
            this.serviceRole = x.serviceRole
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.unmanagedvCpus = x.unmanagedvCpus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.CreateComputeEnvironmentRequest = CreateComputeEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ComputeResource] inside the given [block]
         */
        public fun computeResources(block: aws.sdk.kotlin.services.batch.model.ComputeResource.Builder.() -> kotlin.Unit) {
            this.computeResources = aws.sdk.kotlin.services.batch.model.ComputeResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksConfiguration] inside the given [block]
         */
        public fun eksConfiguration(block: aws.sdk.kotlin.services.batch.model.EksConfiguration.Builder.() -> kotlin.Unit) {
            this.eksConfiguration = aws.sdk.kotlin.services.batch.model.EksConfiguration.invoke(block)
        }
    }
}
