// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `DescribeJobDefinitions`.
 */
public class DescribeJobDefinitionsRequest private constructor(builder: Builder) {
    /**
     * The name of the job definition to describe.
     */
    public val jobDefinitionName: kotlin.String? = builder.jobDefinitionName
    /**
     * A list of up to 100 job definitions. Each entry in the list can either be an ARN in the format `arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}` or a short version using the form `${JobDefinitionName}:${Revision}`.
     */
    public val jobDefinitions: List<String>? = builder.jobDefinitions
    /**
     * The maximum number of results returned by `DescribeJobDefinitions` in paginated output. When this parameter is used, `DescribeJobDefinitions` only returns `maxResults` results in a single page and a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeJobDefinitions` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `DescribeJobDefinitions` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `DescribeJobDefinitions` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
     *
     * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The status used to filter job definitions.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.DescribeJobDefinitionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeJobDefinitionsRequest(")
        append("jobDefinitionName=$jobDefinitionName,")
        append("jobDefinitions=$jobDefinitions,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobDefinitionName?.hashCode() ?: 0
        result = 31 * result + (jobDefinitions?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeJobDefinitionsRequest

        if (jobDefinitionName != other.jobDefinitionName) return false
        if (jobDefinitions != other.jobDefinitions) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.DescribeJobDefinitionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the job definition to describe.
         */
        public var jobDefinitionName: kotlin.String? = null
        /**
         * A list of up to 100 job definitions. Each entry in the list can either be an ARN in the format `arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}` or a short version using the form `${JobDefinitionName}:${Revision}`.
         */
        public var jobDefinitions: List<String>? = null
        /**
         * The maximum number of results returned by `DescribeJobDefinitions` in paginated output. When this parameter is used, `DescribeJobDefinitions` only returns `maxResults` results in a single page and a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeJobDefinitions` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `DescribeJobDefinitions` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `DescribeJobDefinitions` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
         *
         * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The status used to filter job definitions.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.DescribeJobDefinitionsRequest) : this() {
            this.jobDefinitionName = x.jobDefinitionName
            this.jobDefinitions = x.jobDefinitions
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.DescribeJobDefinitionsRequest = DescribeJobDefinitionsRequest(this)
    }
}
