// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Provides information used to select Amazon Machine Images (AMIs) for instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2` ([Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)).
 *
 * This object isn't applicable to jobs that are running on Fargate resources.
 */
public class Ec2Configuration private constructor(builder: Builder) {
    /**
     * The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.
     *
     * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val imageIdOverride: kotlin.String? = builder.imageIdOverride
    /**
     * The Kubernetes version for the compute environment. If you don't specify a value, the latest version that Batch supports is used.
     */
    public val imageKubernetesVersion: kotlin.String? = builder.imageKubernetesVersion
    /**
     * The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.
     *
     * ## ECS
     * If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by Batch is used.
     *
     * ## ECS_AL2
     * [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami): Default for all non-GPU instance families.
     *
     * ## ECS_AL2_NVIDIA
     * [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami): Default for all GPU instance families (for example `P4` and `G4`) and can be used for all non Amazon Web Services Graviton-based instance types.
     *
     * ## ECS_AL1
     * [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami). Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](http://aws.amazon.com/amazon-linux-ami/).
     *
     * ## EKS
     * If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) (`EKS_AL2`) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that Batch supports is used.
     *
     * ## EKS_AL2
     * [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html): Default for all non-GPU instance families.
     *
     * ## EKS_AL2_NVIDIA
     * [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html): Default for all GPU instance families (for example, `P4` and `G4`) and can be used for all non Amazon Web Services Graviton-based instance types.
     */
    public val imageType: kotlin.String? = builder.imageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.Ec2Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2Configuration(")
        append("imageIdOverride=$imageIdOverride,")
        append("imageKubernetesVersion=$imageKubernetesVersion,")
        append("imageType=$imageType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageIdOverride?.hashCode() ?: 0
        result = 31 * result + (imageKubernetesVersion?.hashCode() ?: 0)
        result = 31 * result + (imageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2Configuration

        if (imageIdOverride != other.imageIdOverride) return false
        if (imageKubernetesVersion != other.imageKubernetesVersion) return false
        if (imageType != other.imageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.Ec2Configuration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `imageId` set in the `computeResource` object.
         *
         * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var imageIdOverride: kotlin.String? = null
        /**
         * The Kubernetes version for the compute environment. If you don't specify a value, the latest version that Batch supports is used.
         */
        public var imageKubernetesVersion: kotlin.String? = null
        /**
         * The image type to match with the instance type to select an AMI. The supported values are different for `ECS` and `EKS` resources.
         *
         * ## ECS
         * If the `imageIdOverride` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by Batch is used.
         *
         * ## ECS_AL2
         * [Amazon Linux 2](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami): Default for all non-GPU instance families.
         *
         * ## ECS_AL2_NVIDIA
         * [Amazon Linux 2 (GPU)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami): Default for all GPU instance families (for example `P4` and `G4`) and can be used for all non Amazon Web Services Graviton-based instance types.
         *
         * ## ECS_AL1
         * [Amazon Linux](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami). Amazon Linux has reached the end-of-life of standard support. For more information, see [Amazon Linux AMI](http://aws.amazon.com/amazon-linux-ami/).
         *
         * ## EKS
         * If the `imageIdOverride` parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux AMI](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html) (`EKS_AL2`) is used. If a new image type is specified in an update, but neither an `imageId` nor a `imageIdOverride` parameter is specified, then the latest Amazon EKS optimized AMI for that image type that Batch supports is used.
         *
         * ## EKS_AL2
         * [Amazon Linux 2](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html): Default for all non-GPU instance families.
         *
         * ## EKS_AL2_NVIDIA
         * [Amazon Linux 2 (accelerated)](https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html): Default for all GPU instance families (for example, `P4` and `G4`) and can be used for all non Amazon Web Services Graviton-based instance types.
         */
        public var imageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.Ec2Configuration) : this() {
            this.imageIdOverride = x.imageIdOverride
            this.imageKubernetesVersion = x.imageKubernetesVersion
            this.imageType = x.imageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.Ec2Configuration = Ec2Configuration(this)
    }
}
