// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * This is used when you're using an Amazon Elastic File System file system for job storage. For more information, see [Amazon EFS Volumes](https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html) in the *Batch User Guide*.
 */
public class EfsVolumeConfiguration private constructor(builder: Builder) {
    /**
     * The authorization configuration details for the Amazon EFS file system.
     */
    public val authorizationConfig: aws.sdk.kotlin.services.batch.model.EfsAuthorizationConfig? = builder.authorizationConfig
    /**
     * The Amazon EFS file system ID to use.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.
     *
     * If an EFS access point is specified in the `authorizationConfig`, the root directory parameter must either be omitted or set to `/`, which enforces the path set on the Amazon EFS access point.
     */
    public val rootDirectory: kotlin.String? = builder.rootDirectory
    /**
     * Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide*.
     */
    public val transitEncryption: aws.sdk.kotlin.services.batch.model.EfsTransitEncryption? = builder.transitEncryption
    /**
     * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide*.
     */
    public val transitEncryptionPort: kotlin.Int? = builder.transitEncryptionPort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EfsVolumeConfiguration(")
        append("authorizationConfig=$authorizationConfig,")
        append("fileSystemId=$fileSystemId,")
        append("rootDirectory=$rootDirectory,")
        append("transitEncryption=$transitEncryption,")
        append("transitEncryptionPort=$transitEncryptionPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationConfig?.hashCode() ?: 0
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (rootDirectory?.hashCode() ?: 0)
        result = 31 * result + (transitEncryption?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EfsVolumeConfiguration

        if (authorizationConfig != other.authorizationConfig) return false
        if (fileSystemId != other.fileSystemId) return false
        if (rootDirectory != other.rootDirectory) return false
        if (transitEncryption != other.transitEncryption) return false
        if (transitEncryptionPort != other.transitEncryptionPort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authorization configuration details for the Amazon EFS file system.
         */
        public var authorizationConfig: aws.sdk.kotlin.services.batch.model.EfsAuthorizationConfig? = null
        /**
         * The Amazon EFS file system ID to use.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying `/` has the same effect as omitting this parameter. The maximum length is 4,096 characters.
         *
         * If an EFS access point is specified in the `authorizationConfig`, the root directory parameter must either be omitted or set to `/`, which enforces the path set on the Amazon EFS access point.
         */
        public var rootDirectory: kotlin.String? = null
        /**
         * Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide*.
         */
        public var transitEncryption: aws.sdk.kotlin.services.batch.model.EfsTransitEncryption? = null
        /**
         * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide*.
         */
        public var transitEncryptionPort: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration) : this() {
            this.authorizationConfig = x.authorizationConfig
            this.fileSystemId = x.fileSystemId
            this.rootDirectory = x.rootDirectory
            this.transitEncryption = x.transitEncryption
            this.transitEncryptionPort = x.transitEncryptionPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration = EfsVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EfsAuthorizationConfig] inside the given [block]
         */
        public fun authorizationConfig(block: aws.sdk.kotlin.services.batch.model.EfsAuthorizationConfig.Builder.() -> kotlin.Unit) {
            this.authorizationConfig = aws.sdk.kotlin.services.batch.model.EfsAuthorizationConfig.invoke(block)
        }
    }
}
