// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents the details of a job attempt for a job attempt by an Amazon EKS container.
 */
public class EksAttemptDetail private constructor(builder: Builder) {
    /**
     * The details for the final status of the containers for this job attempt.
     */
    public val containers: List<EksAttemptContainerDetail>? = builder.containers
    /**
     * The name of the node for this job attempt.
     */
    public val nodeName: kotlin.String? = builder.nodeName
    /**
     * The name of the pod for this job attempt.
     */
    public val podName: kotlin.String? = builder.podName
    /**
     * The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the `STARTING` state to the `RUNNING` state).
     */
    public val startedAt: kotlin.Long? = builder.startedAt
    /**
     * A short, human-readable string to provide additional details for the current status of the job attempt.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The Unix timestamp (in milliseconds) for when the attempt was stopped. This happens when the attempt transitioned from the `RUNNING` state to a terminal state, such as `SUCCEEDED` or `FAILED`.
     */
    public val stoppedAt: kotlin.Long? = builder.stoppedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksAttemptDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksAttemptDetail(")
        append("containers=$containers,")
        append("nodeName=$nodeName,")
        append("podName=$podName,")
        append("startedAt=$startedAt,")
        append("statusReason=$statusReason,")
        append("stoppedAt=$stoppedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (nodeName?.hashCode() ?: 0)
        result = 31 * result + (podName?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (stoppedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksAttemptDetail

        if (containers != other.containers) return false
        if (nodeName != other.nodeName) return false
        if (podName != other.podName) return false
        if (startedAt != other.startedAt) return false
        if (statusReason != other.statusReason) return false
        if (stoppedAt != other.stoppedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksAttemptDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The details for the final status of the containers for this job attempt.
         */
        public var containers: List<EksAttemptContainerDetail>? = null
        /**
         * The name of the node for this job attempt.
         */
        public var nodeName: kotlin.String? = null
        /**
         * The name of the pod for this job attempt.
         */
        public var podName: kotlin.String? = null
        /**
         * The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the `STARTING` state to the `RUNNING` state).
         */
        public var startedAt: kotlin.Long? = null
        /**
         * A short, human-readable string to provide additional details for the current status of the job attempt.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The Unix timestamp (in milliseconds) for when the attempt was stopped. This happens when the attempt transitioned from the `RUNNING` state to a terminal state, such as `SUCCEEDED` or `FAILED`.
         */
        public var stoppedAt: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksAttemptDetail) : this() {
            this.containers = x.containers
            this.nodeName = x.nodeName
            this.podName = x.podName
            this.startedAt = x.startedAt
            this.statusReason = x.statusReason
            this.stoppedAt = x.stoppedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksAttemptDetail = EksAttemptDetail(this)
    }
}
