// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Configuration for the Amazon EKS cluster that supports the Batch compute environment. The cluster must exist before the compute environment can be created.
 */
public class EksConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn:<i>aws</i>:eks:<i>us-east-1</i>:<i>123456789012</i>:cluster/<i>ClusterForBatch</i> `.
     */
    public val eksClusterArn: kotlin.String? = builder.eksClusterArn
    /**
     * The namespace of the Amazon EKS cluster. Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default`, can't start with "`kube-`," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`. For more information, see [Namespaces](https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
     */
    public val kubernetesNamespace: kotlin.String? = builder.kubernetesNamespace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksConfiguration(")
        append("eksClusterArn=$eksClusterArn,")
        append("kubernetesNamespace=$kubernetesNamespace)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eksClusterArn?.hashCode() ?: 0
        result = 31 * result + (kubernetesNamespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksConfiguration

        if (eksClusterArn != other.eksClusterArn) return false
        if (kubernetesNamespace != other.kubernetesNamespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is `arn:<i>aws</i>:eks:<i>us-east-1</i>:<i>123456789012</i>:cluster/<i>ClusterForBatch</i> `.
         */
        public var eksClusterArn: kotlin.String? = null
        /**
         * The namespace of the Amazon EKS cluster. Batch manages pods in this namespace. The value can't left empty or null. It must be fewer than 64 characters long, can't be set to `default`, can't start with "`kube-`," and must match this regular expression: `^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`. For more information, see [Namespaces](https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/) in the Kubernetes documentation.
         */
        public var kubernetesNamespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksConfiguration) : this() {
            this.eksClusterArn = x.eksClusterArn
            this.kubernetesNamespace = x.kubernetesNamespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksConfiguration = EksConfiguration(this)
    }
}
