// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The details for container properties that are returned by `DescribeJobs` for jobs that use Amazon EKS.
 */
public class EksContainerDetail private constructor(builder: Builder) {
    /**
     * An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.
     *
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to "`$(NAME1)`" and the `NAME1` environment variable doesn't exist, the command string will remain "`$(NAME1)`". `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [CMD](https://docs.docker.com/engine/reference/builder/#cmd) in the *Dockerfile reference* and [Define a command and arguments for a pod](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation*.
     */
    public val args: List<String>? = builder.args
    /**
     * The entrypoint for the container. For more information, see [Entrypoint](https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation*.
     */
    public val command: List<String>? = builder.command
    /**
     * The environment variables to pass to a container.
     *
     * Environment variables cannot start with "`AWS_BATCH`". This naming convention is reserved for variables that Batch sets.
     */
    public val env: List<EksContainerEnvironmentVariable>? = builder.env
    /**
     * The exit code for the job attempt. A non-zero exit code is considered failed.
     */
    public val exitCode: kotlin.Int? = builder.exitCode
    /**
     * The Docker image used to start the container.
     */
    public val image: kotlin.String? = builder.image
    /**
     * The image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`. This parameter defaults to `Always` if the `:latest` tag is specified, `IfNotPresent` otherwise. For more information, see [Updating images](https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation*.
     */
    public val imagePullPolicy: kotlin.String? = builder.imagePullPolicy
    /**
     * The name of the container. If the name isn't specified, the default name "`Default`" is used. Each container in a pod must have a unique name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A short human-readable string to provide additional details for a running or stopped container. It can be up to 255 characters long.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`. For more information, see [Resource management for pods and containers](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation*.
     */
    public val resources: aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements? = builder.resources
    /**
     * The security context for a job. For more information, see [Configure a security context for a pod or container](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation*.
     */
    public val securityContext: aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext? = builder.securityContext
    /**
     * The volume mounts for the container. Batch supports `emptyDir`, `hostPath`, and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation*.
     */
    public val volumeMounts: List<EksContainerVolumeMount>? = builder.volumeMounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksContainerDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksContainerDetail(")
        append("args=$args,")
        append("command=$command,")
        append("env=$env,")
        append("exitCode=$exitCode,")
        append("image=$image,")
        append("imagePullPolicy=$imagePullPolicy,")
        append("name=$name,")
        append("reason=$reason,")
        append("resources=$resources,")
        append("securityContext=$securityContext,")
        append("volumeMounts=$volumeMounts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = args?.hashCode() ?: 0
        result = 31 * result + (command?.hashCode() ?: 0)
        result = 31 * result + (env?.hashCode() ?: 0)
        result = 31 * result + (exitCode ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (imagePullPolicy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (securityContext?.hashCode() ?: 0)
        result = 31 * result + (volumeMounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksContainerDetail

        if (args != other.args) return false
        if (command != other.command) return false
        if (env != other.env) return false
        if (exitCode != other.exitCode) return false
        if (image != other.image) return false
        if (imagePullPolicy != other.imagePullPolicy) return false
        if (name != other.name) return false
        if (reason != other.reason) return false
        if (resources != other.resources) return false
        if (securityContext != other.securityContext) return false
        if (volumeMounts != other.volumeMounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksContainerDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of arguments to the entrypoint. If this isn't specified, the `CMD` of the container image is used. This corresponds to the `args` member in the [Entrypoint](https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) portion of the [Pod](https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/) in Kubernetes. Environment variable references are expanded using the container's environment.
         *
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to "`$(NAME1)`" and the `NAME1` environment variable doesn't exist, the command string will remain "`$(NAME1)`". `$$` is replaced with `$` and the resulting string isn't expanded. For example, `$$(VAR_NAME)` is passed as `$(VAR_NAME)` whether or not the `VAR_NAME` environment variable exists. For more information, see [CMD](https://docs.docker.com/engine/reference/builder/#cmd) in the *Dockerfile reference* and [Define a command and arguments for a pod](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation*.
         */
        public var args: List<String>? = null
        /**
         * The entrypoint for the container. For more information, see [Entrypoint](https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint) in the *Kubernetes documentation*.
         */
        public var command: List<String>? = null
        /**
         * The environment variables to pass to a container.
         *
         * Environment variables cannot start with "`AWS_BATCH`". This naming convention is reserved for variables that Batch sets.
         */
        public var env: List<EksContainerEnvironmentVariable>? = null
        /**
         * The exit code for the job attempt. A non-zero exit code is considered failed.
         */
        public var exitCode: kotlin.Int? = null
        /**
         * The Docker image used to start the container.
         */
        public var image: kotlin.String? = null
        /**
         * The image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`. This parameter defaults to `Always` if the `:latest` tag is specified, `IfNotPresent` otherwise. For more information, see [Updating images](https://kubernetes.io/docs/concepts/containers/images/#updating-images) in the *Kubernetes documentation*.
         */
        public var imagePullPolicy: kotlin.String? = null
        /**
         * The name of the container. If the name isn't specified, the default name "`Default`" is used. Each container in a pod must have a unique name.
         */
        public var name: kotlin.String? = null
        /**
         * A short human-readable string to provide additional details for a running or stopped container. It can be up to 255 characters long.
         */
        public var reason: kotlin.String? = null
        /**
         * The type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`. For more information, see [Resource management for pods and containers](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation*.
         */
        public var resources: aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements? = null
        /**
         * The security context for a job. For more information, see [Configure a security context for a pod or container](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation*.
         */
        public var securityContext: aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext? = null
        /**
         * The volume mounts for the container. Batch supports `emptyDir`, `hostPath`, and `secret` volume types. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation*.
         */
        public var volumeMounts: List<EksContainerVolumeMount>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksContainerDetail) : this() {
            this.args = x.args
            this.command = x.command
            this.env = x.env
            this.exitCode = x.exitCode
            this.image = x.image
            this.imagePullPolicy = x.imagePullPolicy
            this.name = x.name
            this.reason = x.reason
            this.resources = x.resources
            this.securityContext = x.securityContext
            this.volumeMounts = x.volumeMounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksContainerDetail = EksContainerDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext] inside the given [block]
         */
        public fun securityContext(block: aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext.Builder.() -> kotlin.Unit) {
            this.securityContext = aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext.invoke(block)
        }
    }
}
