// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Object representing any Kubernetes overrides to a job definition that's used in a SubmitJob API operation.
 */
public class EksContainerOverride private constructor(builder: Builder) {
    /**
     * The arguments to the entrypoint to send to the container that overrides the default arguments from the Docker image or the job definition. For more information, see [CMD](https://docs.docker.com/engine/reference/builder/#cmd) in the *Dockerfile reference* and [Define a command an arguments for a pod](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation*.
     */
    public val args: List<String>? = builder.args
    /**
     * The command to send to the container that overrides the default command from the Docker image or the job definition.
     */
    public val command: List<String>? = builder.command
    /**
     * The environment variables to send to the container. You can add new environment variables, which are added to the container at launch. Or, you can override the existing environment variables from the Docker image or the job definition.
     *
     * Environment variables cannot start with "`AWS_BATCH`". This naming convention is reserved for variables that Batch sets.
     */
    public val env: List<EksContainerEnvironmentVariable>? = builder.env
    /**
     * The override of the Docker image that's used to start the container.
     */
    public val image: kotlin.String? = builder.image
    /**
     * The type and amount of resources to assign to a container. These override the settings in the job definition. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`. For more information, see [Resource management for pods and containers](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation*.
     */
    public val resources: aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements? = builder.resources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksContainerOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksContainerOverride(")
        append("args=$args,")
        append("command=$command,")
        append("env=$env,")
        append("image=$image,")
        append("resources=$resources)")
    }

    override fun hashCode(): kotlin.Int {
        var result = args?.hashCode() ?: 0
        result = 31 * result + (command?.hashCode() ?: 0)
        result = 31 * result + (env?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksContainerOverride

        if (args != other.args) return false
        if (command != other.command) return false
        if (env != other.env) return false
        if (image != other.image) return false
        if (resources != other.resources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksContainerOverride = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The arguments to the entrypoint to send to the container that overrides the default arguments from the Docker image or the job definition. For more information, see [CMD](https://docs.docker.com/engine/reference/builder/#cmd) in the *Dockerfile reference* and [Define a command an arguments for a pod](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/) in the *Kubernetes documentation*.
         */
        public var args: List<String>? = null
        /**
         * The command to send to the container that overrides the default command from the Docker image or the job definition.
         */
        public var command: List<String>? = null
        /**
         * The environment variables to send to the container. You can add new environment variables, which are added to the container at launch. Or, you can override the existing environment variables from the Docker image or the job definition.
         *
         * Environment variables cannot start with "`AWS_BATCH`". This naming convention is reserved for variables that Batch sets.
         */
        public var env: List<EksContainerEnvironmentVariable>? = null
        /**
         * The override of the Docker image that's used to start the container.
         */
        public var image: kotlin.String? = null
        /**
         * The type and amount of resources to assign to a container. These override the settings in the job definition. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`. For more information, see [Resource management for pods and containers](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) in the *Kubernetes documentation*.
         */
        public var resources: aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksContainerOverride) : this() {
            this.args = x.args
            this.command = x.command
            this.env = x.env
            this.image = x.image
            this.resources = x.resources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksContainerOverride = EksContainerOverride(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.batch.model.EksContainerResourceRequirements.invoke(block)
        }
    }
}
