// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The security context for a job. For more information, see [Configure a security context for a pod or container](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) in the *Kubernetes documentation*.
 */
public class EksContainerSecurityContext private constructor(builder: Builder) {
    /**
     * When this parameter is `true`, the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false`. This parameter maps to `privileged` policy in the [Privileged pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation*.
     */
    public val privileged: kotlin.Boolean? = builder.privileged
    /**
     * When this parameter is `true`, the container is given read-only access to its root file system. The default value is `false`. This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation*.
     */
    public val readOnlyRootFilesystem: kotlin.Boolean? = builder.readOnlyRootFilesystem
    /**
     * When this parameter is specified, the container is run as the specified group ID (`gid`). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation*.
     */
    public val runAsGroup: kotlin.Long? = builder.runAsGroup
    /**
     * When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation*.
     */
    public val runAsNonRoot: kotlin.Boolean? = builder.runAsNonRoot
    /**
     * When this parameter is specified, the container is run as the specified user ID (`uid`). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation*.
     */
    public val runAsUser: kotlin.Long? = builder.runAsUser

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksContainerSecurityContext(")
        append("privileged=$privileged,")
        append("readOnlyRootFilesystem=$readOnlyRootFilesystem,")
        append("runAsGroup=$runAsGroup,")
        append("runAsNonRoot=$runAsNonRoot,")
        append("runAsUser=$runAsUser)")
    }

    override fun hashCode(): kotlin.Int {
        var result = privileged?.hashCode() ?: 0
        result = 31 * result + (readOnlyRootFilesystem?.hashCode() ?: 0)
        result = 31 * result + (runAsGroup?.hashCode() ?: 0)
        result = 31 * result + (runAsNonRoot?.hashCode() ?: 0)
        result = 31 * result + (runAsUser?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksContainerSecurityContext

        if (privileged != other.privileged) return false
        if (readOnlyRootFilesystem != other.readOnlyRootFilesystem) return false
        if (runAsGroup != other.runAsGroup) return false
        if (runAsNonRoot != other.runAsNonRoot) return false
        if (runAsUser != other.runAsUser) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When this parameter is `true`, the container is given elevated permissions on the host container instance. The level of permissions are similar to the `root` user permissions. The default value is `false`. This parameter maps to `privileged` policy in the [Privileged pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged) in the *Kubernetes documentation*.
         */
        public var privileged: kotlin.Boolean? = null
        /**
         * When this parameter is `true`, the container is given read-only access to its root file system. The default value is `false`. This parameter maps to `ReadOnlyRootFilesystem` policy in the [Volumes and file systems pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems) in the *Kubernetes documentation*.
         */
        public var readOnlyRootFilesystem: kotlin.Boolean? = null
        /**
         * When this parameter is specified, the container is run as the specified group ID (`gid`). If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to `RunAsGroup` and `MustRunAs` policy in the [Users and groups pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation*.
         */
        public var runAsGroup: kotlin.Long? = null
        /**
         * When this parameter is specified, the container is run as a user with a `uid` other than 0. If this parameter isn't specified, so such rule is enforced. This parameter maps to `RunAsUser` and `MustRunAsNonRoot` policy in the [Users and groups pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation*.
         */
        public var runAsNonRoot: kotlin.Boolean? = null
        /**
         * When this parameter is specified, the container is run as the specified user ID (`uid`). If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to `RunAsUser` and `MustRanAs` policy in the [Users and groups pod security policies](https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups) in the *Kubernetes documentation*.
         */
        public var runAsUser: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext) : this() {
            this.privileged = x.privileged
            this.readOnlyRootFilesystem = x.readOnlyRootFilesystem
            this.runAsGroup = x.runAsGroup
            this.runAsNonRoot = x.runAsNonRoot
            this.runAsUser = x.runAsUser
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksContainerSecurityContext = EksContainerSecurityContext(this)
    }
}
