// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The volume mounts for a container for an Amazon EKS job. For more information about volumes and volume mounts in Kubernetes, see [Volumes](https://kubernetes.io/docs/concepts/storage/volumes/) in the *Kubernetes documentation*.
 */
public class EksContainerVolumeMount private constructor(builder: Builder) {
    /**
     * The path on the container where the volume is mounted.
     */
    public val mountPath: kotlin.String? = builder.mountPath
    /**
     * The name the volume mount. This must match the name of one of the volumes in the pod.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If this value is `true`, the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false`.
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksContainerVolumeMount = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksContainerVolumeMount(")
        append("mountPath=$mountPath,")
        append("name=$name,")
        append("readOnly=$readOnly)")
    }

    override fun hashCode(): kotlin.Int {
        var result = mountPath?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksContainerVolumeMount

        if (mountPath != other.mountPath) return false
        if (name != other.name) return false
        if (readOnly != other.readOnly) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksContainerVolumeMount = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path on the container where the volume is mounted.
         */
        public var mountPath: kotlin.String? = null
        /**
         * The name the volume mount. This must match the name of one of the volumes in the pod.
         */
        public var name: kotlin.String? = null
        /**
         * If this value is `true`, the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false`.
         */
        public var readOnly: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksContainerVolumeMount) : this() {
            this.mountPath = x.mountPath
            this.name = x.name
            this.readOnly = x.readOnly
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksContainerVolumeMount = EksContainerVolumeMount(this)
    }
}
