// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Specifies the configuration of a Kubernetes `emptyDir` volume. An `emptyDir` volume is first created when a pod is assigned to a node. It exists as long as that pod is running on that node. The `emptyDir` volume is initially empty. All containers in the pod can read and write the files in the `emptyDir` volume. However, the `emptyDir` volume can be mounted at the same or different paths in each container. When a pod is removed from a node for any reason, the data in the `emptyDir` is deleted permanently. For more information, see [emptyDir](https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the *Kubernetes documentation*.
 */
public class EksEmptyDir private constructor(builder: Builder) {
    /**
     * The medium to store the volume. The default value is an empty string, which uses the storage of the node.
     *
     * ## ""
     * **(Default)** Use the disk storage of the node.
     *
     * ## "Memory"
     * Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
     */
    public val medium: kotlin.String? = builder.medium
    /**
     * The maximum size of the volume. By default, there's no maximum size defined.
     */
    public val sizeLimit: kotlin.String? = builder.sizeLimit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksEmptyDir = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksEmptyDir(")
        append("medium=$medium,")
        append("sizeLimit=$sizeLimit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = medium?.hashCode() ?: 0
        result = 31 * result + (sizeLimit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksEmptyDir

        if (medium != other.medium) return false
        if (sizeLimit != other.sizeLimit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksEmptyDir = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The medium to store the volume. The default value is an empty string, which uses the storage of the node.
         *
         * ## ""
         * **(Default)** Use the disk storage of the node.
         *
         * ## "Memory"
         * Use the `tmpfs` volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.
         */
        public var medium: kotlin.String? = null
        /**
         * The maximum size of the volume. By default, there's no maximum size defined.
         */
        public var sizeLimit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksEmptyDir) : this() {
            this.medium = x.medium
            this.sizeLimit = x.sizeLimit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksEmptyDir = EksEmptyDir(this)
    }
}
