// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The properties for the pod.
 */
public class EksPodProperties private constructor(builder: Builder) {
    /**
     * The properties of the container that's used on the Amazon EKS pod.
     */
    public val containers: List<EksContainer>? = builder.containers
    /**
     * The DNS policy for the pod. The default value is `ClusterFirst`. If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation*.
     *
     * Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet` | `None`
     */
    public val dnsPolicy: kotlin.String? = builder.dnsPolicy
    /**
     * Indicates if the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation*.
     */
    public val hostNetwork: kotlin.Boolean? = builder.hostNetwork
    /**
     * The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation*.
     */
    public val serviceAccountName: kotlin.String? = builder.serviceAccountName
    /**
     * Specifies the volumes for a job definition that uses Amazon EKS resources.
     */
    public val volumes: List<EksVolume>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EksPodProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksPodProperties(")
        append("containers=$containers,")
        append("dnsPolicy=$dnsPolicy,")
        append("hostNetwork=$hostNetwork,")
        append("serviceAccountName=$serviceAccountName,")
        append("volumes=$volumes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (dnsPolicy?.hashCode() ?: 0)
        result = 31 * result + (hostNetwork?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountName?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksPodProperties

        if (containers != other.containers) return false
        if (dnsPolicy != other.dnsPolicy) return false
        if (hostNetwork != other.hostNetwork) return false
        if (serviceAccountName != other.serviceAccountName) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EksPodProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The properties of the container that's used on the Amazon EKS pod.
         */
        public var containers: List<EksContainer>? = null
        /**
         * The DNS policy for the pod. The default value is `ClusterFirst`. If the `hostNetwork` parameter is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see [Pod's DNS policy](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) in the *Kubernetes documentation*.
         *
         * Valid values: `Default` | `ClusterFirst` | `ClusterFirstWithHostNet` | `None`
         */
        public var dnsPolicy: kotlin.String? = null
        /**
         * Indicates if the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see [Host namespaces](https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces) and [Pod networking](https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking) in the *Kubernetes documentation*.
         */
        public var hostNetwork: kotlin.Boolean? = null
        /**
         * The name of the service account that's used to run the pod. For more information, see [Kubernetes service accounts](https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html) and [Configure a Kubernetes service account to assume an IAM role](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html) in the *Amazon EKS User Guide* and [Configure service accounts for pods](https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) in the *Kubernetes documentation*.
         */
        public var serviceAccountName: kotlin.String? = null
        /**
         * Specifies the volumes for a job definition that uses Amazon EKS resources.
         */
        public var volumes: List<EksVolume>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EksPodProperties) : this() {
            this.containers = x.containers
            this.dnsPolicy = x.dnsPolicy
            this.hostNetwork = x.hostNetwork
            this.serviceAccountName = x.serviceAccountName
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EksPodProperties = EksPodProperties(this)
    }
}
