// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Specifies an array of up to 5 conditions to be met, and an action to take (`RETRY` or `EXIT`) if all conditions are met. If none of the `EvaluateOnExit` conditions in a `RetryStrategy` match, then the job is retried.
 */
public class EvaluateOnExit private constructor(builder: Builder) {
    /**
     * Specifies the action to take if all of the specified conditions (`onStatusReason`, `onReason`, and `onExitCode`) are met. The values aren't case sensitive.
     */
    public val action: aws.sdk.kotlin.services.batch.model.RetryAction? = builder.action
    /**
     * Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
     *
     * The string can contain up to 512 characters.
     */
    public val onExitCode: kotlin.String? = builder.onExitCode
    /**
     * Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
     */
    public val onReason: kotlin.String? = builder.onReason
    /**
     * Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
     */
    public val onStatusReason: kotlin.String? = builder.onStatusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.EvaluateOnExit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluateOnExit(")
        append("action=$action,")
        append("onExitCode=$onExitCode,")
        append("onReason=$onReason,")
        append("onStatusReason=$onStatusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (onExitCode?.hashCode() ?: 0)
        result = 31 * result + (onReason?.hashCode() ?: 0)
        result = 31 * result + (onStatusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluateOnExit

        if (action != other.action) return false
        if (onExitCode != other.onExitCode) return false
        if (onReason != other.onReason) return false
        if (onStatusReason != other.onStatusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.EvaluateOnExit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the action to take if all of the specified conditions (`onStatusReason`, `onReason`, and `onExitCode`) are met. The values aren't case sensitive.
         */
        public var action: aws.sdk.kotlin.services.batch.model.RetryAction? = null
        /**
         * Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job. The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
         *
         * The string can contain up to 512 characters.
         */
        public var onExitCode: kotlin.String? = null
        /**
         * Contains a glob pattern to match against the `Reason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         */
        public var onReason: kotlin.String? = null
        /**
         * Contains a glob pattern to match against the `StatusReason` returned for a job. The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         */
        public var onStatusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.EvaluateOnExit) : this() {
            this.action = x.action
            this.onExitCode = x.onExitCode
            this.onReason = x.onReason
            this.onStatusReason = x.onStatusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.EvaluateOnExit = EvaluateOnExit(this)
    }
}
