// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The fair share policy for a scheduling policy.
 */
public class FairsharePolicy private constructor(builder: Builder) {
    /**
     * A value used to reserve some of the available maximum vCPU for fair share identifiers that aren't already used.
     *
     * The reserved ratio is `(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> ` where ` <i>ActiveFairShares</i> ` is the number of active fair share identifiers.
     *
     * For example, a `computeReservation` value of 50 indicates that Batchreserves 50% of the maximum available vCPU if there's only one fair share identifier. It reserves 25% if there are two fair share identifiers. It reserves 12.5% if there are three fair share identifiers. A `computeReservation` value of 25 indicates that Batch should reserve 25% of the maximum available vCPU if there's only one fair share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share identifiers.
     *
     * The minimum value is 0 and the maximum value is 99.
     */
    public val computeReservation: kotlin.Int? = builder.computeReservation
    /**
     * The amount of time (in seconds) to use to calculate a fair share percentage for each fair share identifier in use. A value of zero (0) indicates that only current usage is measured. The decay allows for more recently run jobs to have more weight than jobs that ran earlier. The maximum supported value is 604800 (1 week).
     */
    public val shareDecaySeconds: kotlin.Int? = builder.shareDecaySeconds
    /**
     * An array of `SharedIdentifier` objects that contain the weights for the fair share identifiers for the fair share policy. Fair share identifiers that aren't included have a default weight of `1.0`.
     */
    public val shareDistribution: List<ShareAttributes>? = builder.shareDistribution

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.FairsharePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FairsharePolicy(")
        append("computeReservation=$computeReservation,")
        append("shareDecaySeconds=$shareDecaySeconds,")
        append("shareDistribution=$shareDistribution)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeReservation ?: 0
        result = 31 * result + (shareDecaySeconds ?: 0)
        result = 31 * result + (shareDistribution?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FairsharePolicy

        if (computeReservation != other.computeReservation) return false
        if (shareDecaySeconds != other.shareDecaySeconds) return false
        if (shareDistribution != other.shareDistribution) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.FairsharePolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value used to reserve some of the available maximum vCPU for fair share identifiers that aren't already used.
         *
         * The reserved ratio is `(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> ` where ` <i>ActiveFairShares</i> ` is the number of active fair share identifiers.
         *
         * For example, a `computeReservation` value of 50 indicates that Batchreserves 50% of the maximum available vCPU if there's only one fair share identifier. It reserves 25% if there are two fair share identifiers. It reserves 12.5% if there are three fair share identifiers. A `computeReservation` value of 25 indicates that Batch should reserve 25% of the maximum available vCPU if there's only one fair share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share identifiers.
         *
         * The minimum value is 0 and the maximum value is 99.
         */
        public var computeReservation: kotlin.Int? = null
        /**
         * The amount of time (in seconds) to use to calculate a fair share percentage for each fair share identifier in use. A value of zero (0) indicates that only current usage is measured. The decay allows for more recently run jobs to have more weight than jobs that ran earlier. The maximum supported value is 604800 (1 week).
         */
        public var shareDecaySeconds: kotlin.Int? = null
        /**
         * An array of `SharedIdentifier` objects that contain the weights for the fair share identifiers for the fair share policy. Fair share identifiers that aren't included have a default weight of `1.0`.
         */
        public var shareDistribution: List<ShareAttributes>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.FairsharePolicy) : this() {
            this.computeReservation = x.computeReservation
            this.shareDecaySeconds = x.shareDecaySeconds
            this.shareDistribution = x.shareDistribution
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.FairsharePolicy = FairsharePolicy(this)
    }
}
