// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents an Batch job definition.
 */
public class JobDefinition private constructor(builder: Builder) {
    /**
     * The orchestration type of the compute environment. The valid values are `ECS` (default) or `EKS`.
     */
    public val containerOrchestrationType: aws.sdk.kotlin.services.batch.model.OrchestrationType? = builder.containerOrchestrationType
    /**
     * An object with various properties specific to Amazon ECS based jobs. Valid values are `containerProperties`, `eksProperties`, and `nodeProperties`. Only one can be specified.
     */
    public val containerProperties: aws.sdk.kotlin.services.batch.model.ContainerProperties? = builder.containerProperties
    /**
     * An object with various properties that are specific to Amazon EKS based jobs. Valid values are `containerProperties`, `eksProperties`, and `nodeProperties`. Only one can be specified.
     */
    public val eksProperties: aws.sdk.kotlin.services.batch.model.EksProperties? = builder.eksProperties
    /**
     * The Amazon Resource Name (ARN) for the job definition.
     */
    public val jobDefinitionArn: kotlin.String? = builder.jobDefinitionArn
    /**
     * The name of the job definition.
     */
    public val jobDefinitionName: kotlin.String? = builder.jobDefinitionName
    /**
     * An object with various properties that are specific to multi-node parallel jobs. Valid values are `containerProperties`, `eksProperties`, and `nodeProperties`. Only one can be specified.
     *
     * If the job runs on Fargate resources, don't specify `nodeProperties`. Use `containerProperties` instead.
     */
    public val nodeProperties: aws.sdk.kotlin.services.batch.model.NodeProperties? = builder.nodeProperties
    /**
     * Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a `SubmitJob` request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see [Job definition parameters](https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html) in the *Batch User Guide*.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. Jobs run on Fargate resources specify `FARGATE`.
     */
    public val platformCapabilities: List<PlatformCapability>? = builder.platformCapabilities
    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state.
     */
    public val propagateTags: kotlin.Boolean? = builder.propagateTags
    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    public val retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = builder.retryStrategy
    /**
     * The revision of the job definition.
     */
    public val revision: kotlin.Int? = builder.revision
    /**
     * The scheduling priority of the job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     */
    public val schedulingPriority: kotlin.Int? = builder.schedulingPriority
    /**
     * The status of the job definition.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The tags that are applied to the job definition.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timeout time for jobs that are submitted with this job definition. After the amount of time you specify passes, Batch terminates your jobs if they aren't finished.
     */
    public val timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = builder.timeout
    /**
     * The type of job definition. It's either `container` or `multinode`. If the job is run on Fargate resources, then `multinode` isn't supported. For more information about multi-node parallel jobs, see [Creating a multi-node parallel job definition](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html) in the *Batch User Guide*.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.JobDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobDefinition(")
        append("containerOrchestrationType=$containerOrchestrationType,")
        append("containerProperties=$containerProperties,")
        append("eksProperties=$eksProperties,")
        append("jobDefinitionArn=$jobDefinitionArn,")
        append("jobDefinitionName=$jobDefinitionName,")
        append("nodeProperties=$nodeProperties,")
        append("parameters=$parameters,")
        append("platformCapabilities=$platformCapabilities,")
        append("propagateTags=$propagateTags,")
        append("retryStrategy=$retryStrategy,")
        append("revision=$revision,")
        append("schedulingPriority=$schedulingPriority,")
        append("status=$status,")
        append("tags=$tags,")
        append("timeout=$timeout,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerOrchestrationType?.hashCode() ?: 0
        result = 31 * result + (containerProperties?.hashCode() ?: 0)
        result = 31 * result + (eksProperties?.hashCode() ?: 0)
        result = 31 * result + (jobDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (jobDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (nodeProperties?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (platformCapabilities?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (revision ?: 0)
        result = 31 * result + (schedulingPriority ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeout?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobDefinition

        if (containerOrchestrationType != other.containerOrchestrationType) return false
        if (containerProperties != other.containerProperties) return false
        if (eksProperties != other.eksProperties) return false
        if (jobDefinitionArn != other.jobDefinitionArn) return false
        if (jobDefinitionName != other.jobDefinitionName) return false
        if (nodeProperties != other.nodeProperties) return false
        if (parameters != other.parameters) return false
        if (platformCapabilities != other.platformCapabilities) return false
        if (propagateTags != other.propagateTags) return false
        if (retryStrategy != other.retryStrategy) return false
        if (revision != other.revision) return false
        if (schedulingPriority != other.schedulingPriority) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (timeout != other.timeout) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.JobDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The orchestration type of the compute environment. The valid values are `ECS` (default) or `EKS`.
         */
        public var containerOrchestrationType: aws.sdk.kotlin.services.batch.model.OrchestrationType? = null
        /**
         * An object with various properties specific to Amazon ECS based jobs. Valid values are `containerProperties`, `eksProperties`, and `nodeProperties`. Only one can be specified.
         */
        public var containerProperties: aws.sdk.kotlin.services.batch.model.ContainerProperties? = null
        /**
         * An object with various properties that are specific to Amazon EKS based jobs. Valid values are `containerProperties`, `eksProperties`, and `nodeProperties`. Only one can be specified.
         */
        public var eksProperties: aws.sdk.kotlin.services.batch.model.EksProperties? = null
        /**
         * The Amazon Resource Name (ARN) for the job definition.
         */
        public var jobDefinitionArn: kotlin.String? = null
        /**
         * The name of the job definition.
         */
        public var jobDefinitionName: kotlin.String? = null
        /**
         * An object with various properties that are specific to multi-node parallel jobs. Valid values are `containerProperties`, `eksProperties`, and `nodeProperties`. Only one can be specified.
         *
         * If the job runs on Fargate resources, don't specify `nodeProperties`. Use `containerProperties` instead.
         */
        public var nodeProperties: aws.sdk.kotlin.services.batch.model.NodeProperties? = null
        /**
         * Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a `SubmitJob` request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see [Job definition parameters](https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html) in the *Batch User Guide*.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. Jobs run on Fargate resources specify `FARGATE`.
         */
        public var platformCapabilities: List<PlatformCapability>? = null
        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state.
         */
        public var propagateTags: kotlin.Boolean? = null
        /**
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         */
        public var retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = null
        /**
         * The revision of the job definition.
         */
        public var revision: kotlin.Int? = null
        /**
         * The scheduling priority of the job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
         */
        public var schedulingPriority: kotlin.Int? = null
        /**
         * The status of the job definition.
         */
        public var status: kotlin.String? = null
        /**
         * The tags that are applied to the job definition.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timeout time for jobs that are submitted with this job definition. After the amount of time you specify passes, Batch terminates your jobs if they aren't finished.
         */
        public var timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = null
        /**
         * The type of job definition. It's either `container` or `multinode`. If the job is run on Fargate resources, then `multinode` isn't supported. For more information about multi-node parallel jobs, see [Creating a multi-node parallel job definition](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html) in the *Batch User Guide*.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.JobDefinition) : this() {
            this.containerOrchestrationType = x.containerOrchestrationType
            this.containerProperties = x.containerProperties
            this.eksProperties = x.eksProperties
            this.jobDefinitionArn = x.jobDefinitionArn
            this.jobDefinitionName = x.jobDefinitionName
            this.nodeProperties = x.nodeProperties
            this.parameters = x.parameters
            this.platformCapabilities = x.platformCapabilities
            this.propagateTags = x.propagateTags
            this.retryStrategy = x.retryStrategy
            this.revision = x.revision
            this.schedulingPriority = x.schedulingPriority
            this.status = x.status
            this.tags = x.tags
            this.timeout = x.timeout
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.JobDefinition = JobDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ContainerProperties] inside the given [block]
         */
        public fun containerProperties(block: aws.sdk.kotlin.services.batch.model.ContainerProperties.Builder.() -> kotlin.Unit) {
            this.containerProperties = aws.sdk.kotlin.services.batch.model.ContainerProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksProperties] inside the given [block]
         */
        public fun eksProperties(block: aws.sdk.kotlin.services.batch.model.EksProperties.Builder.() -> kotlin.Unit) {
            this.eksProperties = aws.sdk.kotlin.services.batch.model.EksProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NodeProperties] inside the given [block]
         */
        public fun nodeProperties(block: aws.sdk.kotlin.services.batch.model.NodeProperties.Builder.() -> kotlin.Unit) {
            this.nodeProperties = aws.sdk.kotlin.services.batch.model.NodeProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.RetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.batch.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.batch.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.JobTimeout] inside the given [block]
         */
        public fun timeout(block: aws.sdk.kotlin.services.batch.model.JobTimeout.Builder.() -> kotlin.Unit) {
            this.timeout = aws.sdk.kotlin.services.batch.model.JobTimeout.invoke(block)
        }
    }
}
