// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents an Batch job.
 */
public class JobDetail private constructor(builder: Builder) {
    /**
     * The array properties of the job, if it's an array job.
     */
    public val arrayProperties: aws.sdk.kotlin.services.batch.model.ArrayPropertiesDetail? = builder.arrayProperties
    /**
     * A list of job attempts that are associated with this job.
     */
    public val attempts: List<AttemptDetail>? = builder.attempts
    /**
     * An object that represents the details for the container that's associated with the job.
     */
    public val container: aws.sdk.kotlin.services.batch.model.ContainerDetail? = builder.container
    /**
     * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this is when the job entered the `SUBMITTED` state. This is specifically at the time SubmitJob was called. For array child jobs, this is when the child job was spawned by its parent and entered the `PENDING` state.
     */
    public val createdAt: kotlin.Long? = builder.createdAt
    /**
     * A list of job IDs that this job depends on.
     */
    public val dependsOn: List<JobDependency>? = builder.dependsOn
    /**
     * A list of job attempts that are associated with this job.
     */
    public val eksAttempts: List<EksAttemptDetail>? = builder.eksAttempts
    /**
     * An object with various properties that are specific to Amazon EKS based jobs. Only one of `container`, `eksProperties`, or `nodeDetails` is specified.
     */
    public val eksProperties: aws.sdk.kotlin.services.batch.model.EksPropertiesDetail? = builder.eksProperties
    /**
     * The Amazon Resource Name (ARN) of the job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The Amazon Resource Name (ARN) of the job definition that this job uses.
     */
    public val jobDefinition: kotlin.String? = builder.jobDefinition
    /**
     * The job ID.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The job name.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     */
    public val jobQueue: kotlin.String? = builder.jobQueue
    /**
     * An object that represents the details of a node that's associated with a multi-node parallel job.
     */
    public val nodeDetails: aws.sdk.kotlin.services.batch.model.NodeDetails? = builder.nodeDetails
    /**
     * An object that represents the node properties of a multi-node parallel job.
     *
     * This isn't applicable to jobs that are running on Fargate resources.
     */
    public val nodeProperties: aws.sdk.kotlin.services.batch.model.NodeProperties? = builder.nodeProperties
    /**
     * Additional parameters that are passed to the job that replace parameter substitution placeholders or override any corresponding parameter defaults from the job definition.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. Jobs run on Fargate resources specify `FARGATE`.
     */
    public val platformCapabilities: List<PlatformCapability>? = builder.platformCapabilities
    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state.
     */
    public val propagateTags: kotlin.Boolean? = builder.propagateTags
    /**
     * The retry strategy to use for this job if an attempt fails.
     */
    public val retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = builder.retryStrategy
    /**
     * The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     */
    public val schedulingPriority: kotlin.Int? = builder.schedulingPriority
    /**
     * The share identifier for the job.
     */
    public val shareIdentifier: kotlin.String? = builder.shareIdentifier
    /**
     * The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job transitioned from the `STARTING` state to the `RUNNING` state. This parameter isn't provided for child jobs of array jobs or multi-node parallel jobs.
     */
    public val startedAt: kotlin.Long? = builder.startedAt
    /**
     * The current status for the job.
     *
     * If your jobs don't progress to `STARTING`, see [Jobs stuck in RUNNABLE status](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable) in the troubleshooting section of the *Batch User Guide*.
     */
    public val status: aws.sdk.kotlin.services.batch.model.JobStatus? = builder.status
    /**
     * A short, human-readable string to provide more details for the current status of the job.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job transitioned from the `RUNNING` state to a terminal state, such as `SUCCEEDED` or `FAILED`.
     */
    public val stoppedAt: kotlin.Long? = builder.stoppedAt
    /**
     * The tags that are applied to the job.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timeout configuration for the job.
     */
    public val timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = builder.timeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.JobDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobDetail(")
        append("arrayProperties=$arrayProperties,")
        append("attempts=$attempts,")
        append("container=$container,")
        append("createdAt=$createdAt,")
        append("dependsOn=$dependsOn,")
        append("eksAttempts=$eksAttempts,")
        append("eksProperties=$eksProperties,")
        append("jobArn=$jobArn,")
        append("jobDefinition=$jobDefinition,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobQueue=$jobQueue,")
        append("nodeDetails=$nodeDetails,")
        append("nodeProperties=$nodeProperties,")
        append("parameters=$parameters,")
        append("platformCapabilities=$platformCapabilities,")
        append("propagateTags=$propagateTags,")
        append("retryStrategy=$retryStrategy,")
        append("schedulingPriority=$schedulingPriority,")
        append("shareIdentifier=$shareIdentifier,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("stoppedAt=$stoppedAt,")
        append("tags=$tags,")
        append("timeout=$timeout)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrayProperties?.hashCode() ?: 0
        result = 31 * result + (attempts?.hashCode() ?: 0)
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dependsOn?.hashCode() ?: 0)
        result = 31 * result + (eksAttempts?.hashCode() ?: 0)
        result = 31 * result + (eksProperties?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobDefinition?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobQueue?.hashCode() ?: 0)
        result = 31 * result + (nodeDetails?.hashCode() ?: 0)
        result = 31 * result + (nodeProperties?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (platformCapabilities?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (schedulingPriority ?: 0)
        result = 31 * result + (shareIdentifier?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (stoppedAt?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeout?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobDetail

        if (arrayProperties != other.arrayProperties) return false
        if (attempts != other.attempts) return false
        if (container != other.container) return false
        if (createdAt != other.createdAt) return false
        if (dependsOn != other.dependsOn) return false
        if (eksAttempts != other.eksAttempts) return false
        if (eksProperties != other.eksProperties) return false
        if (jobArn != other.jobArn) return false
        if (jobDefinition != other.jobDefinition) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobQueue != other.jobQueue) return false
        if (nodeDetails != other.nodeDetails) return false
        if (nodeProperties != other.nodeProperties) return false
        if (parameters != other.parameters) return false
        if (platformCapabilities != other.platformCapabilities) return false
        if (propagateTags != other.propagateTags) return false
        if (retryStrategy != other.retryStrategy) return false
        if (schedulingPriority != other.schedulingPriority) return false
        if (shareIdentifier != other.shareIdentifier) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (stoppedAt != other.stoppedAt) return false
        if (tags != other.tags) return false
        if (timeout != other.timeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.JobDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The array properties of the job, if it's an array job.
         */
        public var arrayProperties: aws.sdk.kotlin.services.batch.model.ArrayPropertiesDetail? = null
        /**
         * A list of job attempts that are associated with this job.
         */
        public var attempts: List<AttemptDetail>? = null
        /**
         * An object that represents the details for the container that's associated with the job.
         */
        public var container: aws.sdk.kotlin.services.batch.model.ContainerDetail? = null
        /**
         * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this is when the job entered the `SUBMITTED` state. This is specifically at the time SubmitJob was called. For array child jobs, this is when the child job was spawned by its parent and entered the `PENDING` state.
         */
        public var createdAt: kotlin.Long? = null
        /**
         * A list of job IDs that this job depends on.
         */
        public var dependsOn: List<JobDependency>? = null
        /**
         * A list of job attempts that are associated with this job.
         */
        public var eksAttempts: List<EksAttemptDetail>? = null
        /**
         * An object with various properties that are specific to Amazon EKS based jobs. Only one of `container`, `eksProperties`, or `nodeDetails` is specified.
         */
        public var eksProperties: aws.sdk.kotlin.services.batch.model.EksPropertiesDetail? = null
        /**
         * The Amazon Resource Name (ARN) of the job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the job definition that this job uses.
         */
        public var jobDefinition: kotlin.String? = null
        /**
         * The job ID.
         */
        public var jobId: kotlin.String? = null
        /**
         * The job name.
         */
        public var jobName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the job queue that the job is associated with.
         */
        public var jobQueue: kotlin.String? = null
        /**
         * An object that represents the details of a node that's associated with a multi-node parallel job.
         */
        public var nodeDetails: aws.sdk.kotlin.services.batch.model.NodeDetails? = null
        /**
         * An object that represents the node properties of a multi-node parallel job.
         *
         * This isn't applicable to jobs that are running on Fargate resources.
         */
        public var nodeProperties: aws.sdk.kotlin.services.batch.model.NodeProperties? = null
        /**
         * Additional parameters that are passed to the job that replace parameter substitution placeholders or override any corresponding parameter defaults from the job definition.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. Jobs run on Fargate resources specify `FARGATE`.
         */
        public var platformCapabilities: List<PlatformCapability>? = null
        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state.
         */
        public var propagateTags: kotlin.Boolean? = null
        /**
         * The retry strategy to use for this job if an attempt fails.
         */
        public var retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = null
        /**
         * The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
         */
        public var schedulingPriority: kotlin.Int? = null
        /**
         * The share identifier for the job.
         */
        public var shareIdentifier: kotlin.String? = null
        /**
         * The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job transitioned from the `STARTING` state to the `RUNNING` state. This parameter isn't provided for child jobs of array jobs or multi-node parallel jobs.
         */
        public var startedAt: kotlin.Long? = null
        /**
         * The current status for the job.
         *
         * If your jobs don't progress to `STARTING`, see [Jobs stuck in RUNNABLE status](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable) in the troubleshooting section of the *Batch User Guide*.
         */
        public var status: aws.sdk.kotlin.services.batch.model.JobStatus? = null
        /**
         * A short, human-readable string to provide more details for the current status of the job.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job transitioned from the `RUNNING` state to a terminal state, such as `SUCCEEDED` or `FAILED`.
         */
        public var stoppedAt: kotlin.Long? = null
        /**
         * The tags that are applied to the job.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timeout configuration for the job.
         */
        public var timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.JobDetail) : this() {
            this.arrayProperties = x.arrayProperties
            this.attempts = x.attempts
            this.container = x.container
            this.createdAt = x.createdAt
            this.dependsOn = x.dependsOn
            this.eksAttempts = x.eksAttempts
            this.eksProperties = x.eksProperties
            this.jobArn = x.jobArn
            this.jobDefinition = x.jobDefinition
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobQueue = x.jobQueue
            this.nodeDetails = x.nodeDetails
            this.nodeProperties = x.nodeProperties
            this.parameters = x.parameters
            this.platformCapabilities = x.platformCapabilities
            this.propagateTags = x.propagateTags
            this.retryStrategy = x.retryStrategy
            this.schedulingPriority = x.schedulingPriority
            this.shareIdentifier = x.shareIdentifier
            this.startedAt = x.startedAt
            this.status = x.status
            this.statusReason = x.statusReason
            this.stoppedAt = x.stoppedAt
            this.tags = x.tags
            this.timeout = x.timeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.JobDetail = JobDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ArrayPropertiesDetail] inside the given [block]
         */
        public fun arrayProperties(block: aws.sdk.kotlin.services.batch.model.ArrayPropertiesDetail.Builder.() -> kotlin.Unit) {
            this.arrayProperties = aws.sdk.kotlin.services.batch.model.ArrayPropertiesDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ContainerDetail] inside the given [block]
         */
        public fun container(block: aws.sdk.kotlin.services.batch.model.ContainerDetail.Builder.() -> kotlin.Unit) {
            this.container = aws.sdk.kotlin.services.batch.model.ContainerDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksPropertiesDetail] inside the given [block]
         */
        public fun eksProperties(block: aws.sdk.kotlin.services.batch.model.EksPropertiesDetail.Builder.() -> kotlin.Unit) {
            this.eksProperties = aws.sdk.kotlin.services.batch.model.EksPropertiesDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NodeDetails] inside the given [block]
         */
        public fun nodeDetails(block: aws.sdk.kotlin.services.batch.model.NodeDetails.Builder.() -> kotlin.Unit) {
            this.nodeDetails = aws.sdk.kotlin.services.batch.model.NodeDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NodeProperties] inside the given [block]
         */
        public fun nodeProperties(block: aws.sdk.kotlin.services.batch.model.NodeProperties.Builder.() -> kotlin.Unit) {
            this.nodeProperties = aws.sdk.kotlin.services.batch.model.NodeProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.RetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.batch.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.batch.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.JobTimeout] inside the given [block]
         */
        public fun timeout(block: aws.sdk.kotlin.services.batch.model.JobTimeout.Builder.() -> kotlin.Unit) {
            this.timeout = aws.sdk.kotlin.services.batch.model.JobTimeout.invoke(block)
        }
    }
}
