// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents summary details of a job.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The array properties of the job, if it's an array job.
     */
    public val arrayProperties: aws.sdk.kotlin.services.batch.model.ArrayPropertiesSummary? = builder.arrayProperties
    /**
     * An object that represents the details of the container that's associated with the job.
     */
    public val container: aws.sdk.kotlin.services.batch.model.ContainerSummary? = builder.container
    /**
     * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this is when the job entered the `SUBMITTED` state (at the time SubmitJob was called). For array child jobs, this is when the child job was spawned by its parent and entered the `PENDING` state.
     */
    public val createdAt: kotlin.Long? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) of the job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The Amazon Resource Name (ARN) of the job definition.
     */
    public val jobDefinition: kotlin.String? = builder.jobDefinition
    /**
     * The job ID.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The job name.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The node properties for a single node in a job summary list.
     *
     * This isn't applicable to jobs that are running on Fargate resources.
     */
    public val nodeProperties: aws.sdk.kotlin.services.batch.model.NodePropertiesSummary? = builder.nodeProperties
    /**
     * The Unix timestamp for when the job was started. More specifically, it's when the job transitioned from the `STARTING` state to the `RUNNING` state.
     */
    public val startedAt: kotlin.Long? = builder.startedAt
    /**
     * The current status for the job.
     */
    public val status: aws.sdk.kotlin.services.batch.model.JobStatus? = builder.status
    /**
     * A short, human-readable string to provide more details for the current status of the job.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The Unix timestamp for when the job was stopped. More specifically, it's when the job transitioned from the `RUNNING` state to a terminal state, such as `SUCCEEDED` or `FAILED`.
     */
    public val stoppedAt: kotlin.Long? = builder.stoppedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("arrayProperties=$arrayProperties,")
        append("container=$container,")
        append("createdAt=$createdAt,")
        append("jobArn=$jobArn,")
        append("jobDefinition=$jobDefinition,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("nodeProperties=$nodeProperties,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("stoppedAt=$stoppedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrayProperties?.hashCode() ?: 0
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobDefinition?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (nodeProperties?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (stoppedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (arrayProperties != other.arrayProperties) return false
        if (container != other.container) return false
        if (createdAt != other.createdAt) return false
        if (jobArn != other.jobArn) return false
        if (jobDefinition != other.jobDefinition) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (nodeProperties != other.nodeProperties) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (stoppedAt != other.stoppedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.JobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The array properties of the job, if it's an array job.
         */
        public var arrayProperties: aws.sdk.kotlin.services.batch.model.ArrayPropertiesSummary? = null
        /**
         * An object that represents the details of the container that's associated with the job.
         */
        public var container: aws.sdk.kotlin.services.batch.model.ContainerSummary? = null
        /**
         * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this is when the job entered the `SUBMITTED` state (at the time SubmitJob was called). For array child jobs, this is when the child job was spawned by its parent and entered the `PENDING` state.
         */
        public var createdAt: kotlin.Long? = null
        /**
         * The Amazon Resource Name (ARN) of the job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the job definition.
         */
        public var jobDefinition: kotlin.String? = null
        /**
         * The job ID.
         */
        public var jobId: kotlin.String? = null
        /**
         * The job name.
         */
        public var jobName: kotlin.String? = null
        /**
         * The node properties for a single node in a job summary list.
         *
         * This isn't applicable to jobs that are running on Fargate resources.
         */
        public var nodeProperties: aws.sdk.kotlin.services.batch.model.NodePropertiesSummary? = null
        /**
         * The Unix timestamp for when the job was started. More specifically, it's when the job transitioned from the `STARTING` state to the `RUNNING` state.
         */
        public var startedAt: kotlin.Long? = null
        /**
         * The current status for the job.
         */
        public var status: aws.sdk.kotlin.services.batch.model.JobStatus? = null
        /**
         * A short, human-readable string to provide more details for the current status of the job.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The Unix timestamp for when the job was stopped. More specifically, it's when the job transitioned from the `RUNNING` state to a terminal state, such as `SUCCEEDED` or `FAILED`.
         */
        public var stoppedAt: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.JobSummary) : this() {
            this.arrayProperties = x.arrayProperties
            this.container = x.container
            this.createdAt = x.createdAt
            this.jobArn = x.jobArn
            this.jobDefinition = x.jobDefinition
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.nodeProperties = x.nodeProperties
            this.startedAt = x.startedAt
            this.status = x.status
            this.statusReason = x.statusReason
            this.stoppedAt = x.stoppedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.JobSummary = JobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ArrayPropertiesSummary] inside the given [block]
         */
        public fun arrayProperties(block: aws.sdk.kotlin.services.batch.model.ArrayPropertiesSummary.Builder.() -> kotlin.Unit) {
            this.arrayProperties = aws.sdk.kotlin.services.batch.model.ArrayPropertiesSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ContainerSummary] inside the given [block]
         */
        public fun container(block: aws.sdk.kotlin.services.batch.model.ContainerSummary.Builder.() -> kotlin.Unit) {
            this.container = aws.sdk.kotlin.services.batch.model.ContainerSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NodePropertiesSummary] inside the given [block]
         */
        public fun nodeProperties(block: aws.sdk.kotlin.services.batch.model.NodePropertiesSummary.Builder.() -> kotlin.Unit) {
            this.nodeProperties = aws.sdk.kotlin.services.batch.model.NodePropertiesSummary.invoke(block)
        }
    }
}
