// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents a launch template that's associated with a compute resource. You must specify either the launch template ID or launch template name in the request, but not both.
 *
 * If security groups are specified using both the `securityGroupIds` parameter of `CreateComputeEnvironment` and the launch template, the values in the `securityGroupIds` parameter of `CreateComputeEnvironment` will be used.
 *
 * This object isn't applicable to jobs that are running on Fargate resources.
 */
public class LaunchTemplateSpecification private constructor(builder: Builder) {
    /**
     * The ID of the launch template.
     */
    public val launchTemplateId: kotlin.String? = builder.launchTemplateId
    /**
     * The name of the launch template.
     */
    public val launchTemplateName: kotlin.String? = builder.launchTemplateName
    /**
     * The version number of the launch template, `$Latest`, or `$Default`.
     *
     * If the value is `$Latest`, the latest version of the launch template is used. If the value is `$Default`, the default version of the launch template is used.
     *
     * If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true`. During an infrastructure update, if either `$Latest` or `$Default` is specified, Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * Default: `$Default`.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateSpecification(")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchTemplateId?.hashCode() ?: 0
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchTemplateSpecification

        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the launch template.
         */
        public var launchTemplateId: kotlin.String? = null
        /**
         * The name of the launch template.
         */
        public var launchTemplateName: kotlin.String? = null
        /**
         * The version number of the launch template, `$Latest`, or `$Default`.
         *
         * If the value is `$Latest`, the latest version of the launch template is used. If the value is `$Default`, the default version of the launch template is used.
         *
         * If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the `updateToLatestImageVersion` parameter for the compute environment is set to `true`. During an infrastructure update, if either `$Latest` or `$Default` is specified, Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * Default: `$Default`.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification) : this() {
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification = LaunchTemplateSpecification(this)
    }
}
