// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Linux-specific modifications that are applied to the container, such as details for device mappings.
 */
public class LinuxParameters private constructor(builder: Builder) {
    /**
     * Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
     */
    public val devices: List<Device>? = builder.devices
    /**
     * If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.docker.com/engine/reference/run/). This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
     */
    public val initProcessEnabled: kotlin.Boolean? = builder.initProcessEnabled
    /**
     * The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see `--memory-swap`[ details](https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.
     *
     * If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance that it's running on. A `maxSwap` value must be set for the `swappiness` parameter to be used.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
     */
    public val maxSwap: kotlin.Int? = builder.maxSwap
    /**
     * The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
     */
    public val sharedMemorySize: kotlin.Int? = builder.sharedMemorySize
    /**
     * You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100`. If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap`, then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * Consider the following when you use a per-container swap configuration.
     * + Swap space must be enabled and allocated on the container instance for the containers to use.By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](http://aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
     * + The swap space parameters are only supported for job definitions using EC2 resources.
     * + If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
     */
    public val swappiness: kotlin.Int? = builder.swappiness
    /**
     * The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
     */
    public val tmpfs: List<Tmpfs>? = builder.tmpfs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.LinuxParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LinuxParameters(")
        append("devices=$devices,")
        append("initProcessEnabled=$initProcessEnabled,")
        append("maxSwap=$maxSwap,")
        append("sharedMemorySize=$sharedMemorySize,")
        append("swappiness=$swappiness,")
        append("tmpfs=$tmpfs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = devices?.hashCode() ?: 0
        result = 31 * result + (initProcessEnabled?.hashCode() ?: 0)
        result = 31 * result + (maxSwap ?: 0)
        result = 31 * result + (sharedMemorySize ?: 0)
        result = 31 * result + (swappiness ?: 0)
        result = 31 * result + (tmpfs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LinuxParameters

        if (devices != other.devices) return false
        if (initProcessEnabled != other.initProcessEnabled) return false
        if (maxSwap != other.maxSwap) return false
        if (sharedMemorySize != other.sharedMemorySize) return false
        if (swappiness != other.swappiness) return false
        if (tmpfs != other.tmpfs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.LinuxParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Any of the host devices to expose to the container. This parameter maps to `Devices` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--device` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         */
        public var devices: List<Device>? = null
        /**
         * If true, run an `init` process inside the container that forwards signals and reaps processes. This parameter maps to the `--init` option to [docker run](https://docs.docker.com/engine/reference/run/). This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version | grep "Server API version"`
         */
        public var initProcessEnabled: kotlin.Boolean? = null
        /**
         * The total amount of swap memory (in MiB) a container can use. This parameter is translated to the `--memory-swap` option to [docker run](https://docs.docker.com/engine/reference/run/) where the value is the sum of the container memory plus the `maxSwap` value. For more information, see `--memory-swap`[ details](https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details) in the Docker documentation.
         *
         * If a `maxSwap` value of `0` is specified, the container doesn't use swap. Accepted values are `0` or any positive integer. If the `maxSwap` parameter is omitted, the container doesn't use the swap configuration for the container instance that it's running on. A `maxSwap` value must be set for the `swappiness` parameter to be used.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         */
        public var maxSwap: kotlin.Int? = null
        /**
         * The value for the size (in MiB) of the `/dev/shm` volume. This parameter maps to the `--shm-size` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         */
        public var sharedMemorySize: kotlin.Int? = null
        /**
         * You can use this parameter to tune a container's memory swappiness behavior. A `swappiness` value of `0` causes swapping to not occur unless absolutely necessary. A `swappiness` value of `100` causes pages to be swapped aggressively. Valid values are whole numbers between `0` and `100`. If the `swappiness` parameter isn't specified, a default value of `60` is used. If a value isn't specified for `maxSwap`, then this parameter is ignored. If `maxSwap` is set to 0, the container doesn't use swap. This parameter maps to the `--memory-swappiness` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * Consider the following when you use a per-container swap configuration.
         * + Swap space must be enabled and allocated on the container instance for the containers to use.By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see [Instance store swap volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html) in the *Amazon EC2 User Guide for Linux Instances* or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?](http://aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
         * + The swap space parameters are only supported for job definitions using EC2 resources.
         * + If the `maxSwap` and `swappiness` parameters are omitted from a job definition, each container has a default `swappiness` value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         */
        public var swappiness: kotlin.Int? = null
        /**
         * The container path, mount options, and size (in MiB) of the `tmpfs` mount. This parameter maps to the `--tmpfs` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
         */
        public var tmpfs: List<Tmpfs>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.LinuxParameters) : this() {
            this.devices = x.devices
            this.initProcessEnabled = x.initProcessEnabled
            this.maxSwap = x.maxSwap
            this.sharedMemorySize = x.sharedMemorySize
            this.swappiness = x.swappiness
            this.tmpfs = x.tmpfs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.LinuxParameters = LinuxParameters(this)
    }
}
