// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Details for a Docker volume mount point that's used in a job's container properties. This parameter maps to `Volumes` in the [Create a container](https://docs.docker.com/engine/reference/api/docker_remote_api_v1.19/#create-a-container) section of the *Docker Remote API* and the `--volume` option to docker run.
 */
public class MountPoint private constructor(builder: Builder) {
    /**
     * The path on the container where the host volume is mounted.
     */
    public val containerPath: kotlin.String? = builder.containerPath
    /**
     * If this value is `true`, the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false`.
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * The name of the volume to mount.
     */
    public val sourceVolume: kotlin.String? = builder.sourceVolume

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.MountPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MountPoint(")
        append("containerPath=$containerPath,")
        append("readOnly=$readOnly,")
        append("sourceVolume=$sourceVolume)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerPath?.hashCode() ?: 0
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (sourceVolume?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MountPoint

        if (containerPath != other.containerPath) return false
        if (readOnly != other.readOnly) return false
        if (sourceVolume != other.sourceVolume) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.MountPoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path on the container where the host volume is mounted.
         */
        public var containerPath: kotlin.String? = null
        /**
         * If this value is `true`, the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is `false`.
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * The name of the volume to mount.
         */
        public var sourceVolume: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.MountPoint) : this() {
            this.containerPath = x.containerPath
            this.readOnly = x.readOnly
            this.sourceVolume = x.sourceVolume
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.MountPoint = MountPoint(this)
    }
}
