// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents the node properties of a multi-node parallel job.
 *
 * Node properties can't be specified for Amazon EKS based job definitions.
 */
public class NodeProperties private constructor(builder: Builder) {
    /**
     * Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
     */
    public val mainNode: kotlin.Int? = builder.mainNode
    /**
     * A list of node ranges and their properties that are associated with a multi-node parallel job.
     */
    public val nodeRangeProperties: List<NodeRangeProperty>? = builder.nodeRangeProperties
    /**
     * The number of nodes that are associated with a multi-node parallel job.
     */
    public val numNodes: kotlin.Int? = builder.numNodes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.NodeProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeProperties(")
        append("mainNode=$mainNode,")
        append("nodeRangeProperties=$nodeRangeProperties,")
        append("numNodes=$numNodes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = mainNode ?: 0
        result = 31 * result + (nodeRangeProperties?.hashCode() ?: 0)
        result = 31 * result + (numNodes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeProperties

        if (mainNode != other.mainNode) return false
        if (nodeRangeProperties != other.nodeRangeProperties) return false
        if (numNodes != other.numNodes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.NodeProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
         */
        public var mainNode: kotlin.Int? = null
        /**
         * A list of node ranges and their properties that are associated with a multi-node parallel job.
         */
        public var nodeRangeProperties: List<NodeRangeProperty>? = null
        /**
         * The number of nodes that are associated with a multi-node parallel job.
         */
        public var numNodes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.NodeProperties) : this() {
            this.mainNode = x.mainNode
            this.nodeRangeProperties = x.nodeRangeProperties
            this.numNodes = x.numNodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.NodeProperties = NodeProperties(this)
    }
}
