// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `RegisterJobDefinition`.
 */
public class RegisterJobDefinitionRequest private constructor(builder: Builder) {
    /**
     * An object with various properties specific to Amazon ECS based single-node container-based jobs. If the job definition's `type` parameter is `container`, then you must specify either `containerProperties` or `nodeProperties`. This must not be specified for Amazon EKS based job definitions.
     *
     * If the job runs on Fargate resources, then you must not specify `nodeProperties`; use only `containerProperties`.
     */
    public val containerProperties: aws.sdk.kotlin.services.batch.model.ContainerProperties? = builder.containerProperties
    /**
     * An object with various properties that are specific to Amazon EKS based jobs. This must not be specified for Amazon ECS based job definitions.
     */
    public val eksProperties: aws.sdk.kotlin.services.batch.model.EksProperties? = builder.eksProperties
    /**
     * The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public val jobDefinitionName: kotlin.String? = builder.jobDefinitionName
    /**
     * An object with various properties specific to multi-node parallel jobs. If you specify node properties for a job, it becomes a multi-node parallel job. For more information, see [Multi-node Parallel Jobs](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-parallel-jobs.html) in the *Batch User Guide*. If the job definition's `type` parameter is `container`, then you must specify either `containerProperties` or `nodeProperties`.
     *
     * If the job runs on Fargate resources, then you must not specify `nodeProperties`; use `containerProperties` instead.
     *
     * If the job runs on Amazon EKS resources, then you must not specify `nodeProperties`.
     */
    public val nodeProperties: aws.sdk.kotlin.services.batch.model.NodeProperties? = builder.nodeProperties
    /**
     * Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a `SubmitJob` request override any corresponding parameter defaults from the job definition.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
     *
     * If the job runs on Amazon EKS resources, then you must not specify `platformCapabilities`.
     */
    public val platformCapabilities: List<PlatformCapability>? = builder.platformCapabilities
    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state.
     *
     * If the job runs on Amazon EKS resources, then you must not specify `propagateTags`.
     */
    public val propagateTags: kotlin.Boolean? = builder.propagateTags
    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that's specified during a SubmitJob operation overrides the retry strategy defined here. If a job is terminated due to a timeout, it isn't retried.
     */
    public val retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = builder.retryStrategy
    /**
     * The scheduling priority for jobs that are submitted with this job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     *
     * The minimum supported value is 0 and the maximum supported value is 9999.
     */
    public val schedulingPriority: kotlin.Int? = builder.schedulingPriority
    /**
     * The tags that you apply to the job definition to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html) in *Batch User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timeout configuration for jobs that are submitted with this job definition, after which Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds. Any timeout configuration that's specified during a SubmitJob operation overrides the timeout configuration defined here. For more information, see [Job Timeouts](https://docs.aws.amazon.com/batch/latest/userguide/job_timeouts.html) in the *Batch User Guide*.
     */
    public val timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = builder.timeout
    /**
     * The type of job definition. For more information about multi-node parallel jobs, see [Creating a multi-node parallel job definition](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html) in the *Batch User Guide*.
     *
     * If the job is run on Fargate resources, then `multinode` isn't supported.
     */
    public val type: aws.sdk.kotlin.services.batch.model.JobDefinitionType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.RegisterJobDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterJobDefinitionRequest(")
        append("containerProperties=$containerProperties,")
        append("eksProperties=$eksProperties,")
        append("jobDefinitionName=$jobDefinitionName,")
        append("nodeProperties=$nodeProperties,")
        append("parameters=$parameters,")
        append("platformCapabilities=$platformCapabilities,")
        append("propagateTags=$propagateTags,")
        append("retryStrategy=$retryStrategy,")
        append("schedulingPriority=$schedulingPriority,")
        append("tags=$tags,")
        append("timeout=$timeout,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerProperties?.hashCode() ?: 0
        result = 31 * result + (eksProperties?.hashCode() ?: 0)
        result = 31 * result + (jobDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (nodeProperties?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (platformCapabilities?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (schedulingPriority ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeout?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterJobDefinitionRequest

        if (containerProperties != other.containerProperties) return false
        if (eksProperties != other.eksProperties) return false
        if (jobDefinitionName != other.jobDefinitionName) return false
        if (nodeProperties != other.nodeProperties) return false
        if (parameters != other.parameters) return false
        if (platformCapabilities != other.platformCapabilities) return false
        if (propagateTags != other.propagateTags) return false
        if (retryStrategy != other.retryStrategy) return false
        if (schedulingPriority != other.schedulingPriority) return false
        if (tags != other.tags) return false
        if (timeout != other.timeout) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.RegisterJobDefinitionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object with various properties specific to Amazon ECS based single-node container-based jobs. If the job definition's `type` parameter is `container`, then you must specify either `containerProperties` or `nodeProperties`. This must not be specified for Amazon EKS based job definitions.
         *
         * If the job runs on Fargate resources, then you must not specify `nodeProperties`; use only `containerProperties`.
         */
        public var containerProperties: aws.sdk.kotlin.services.batch.model.ContainerProperties? = null
        /**
         * An object with various properties that are specific to Amazon EKS based jobs. This must not be specified for Amazon ECS based job definitions.
         */
        public var eksProperties: aws.sdk.kotlin.services.batch.model.EksProperties? = null
        /**
         * The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         */
        public var jobDefinitionName: kotlin.String? = null
        /**
         * An object with various properties specific to multi-node parallel jobs. If you specify node properties for a job, it becomes a multi-node parallel job. For more information, see [Multi-node Parallel Jobs](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-parallel-jobs.html) in the *Batch User Guide*. If the job definition's `type` parameter is `container`, then you must specify either `containerProperties` or `nodeProperties`.
         *
         * If the job runs on Fargate resources, then you must not specify `nodeProperties`; use `containerProperties` instead.
         *
         * If the job runs on Amazon EKS resources, then you must not specify `nodeProperties`.
         */
        public var nodeProperties: aws.sdk.kotlin.services.batch.model.NodeProperties? = null
        /**
         * Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a `SubmitJob` request override any corresponding parameter defaults from the job definition.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
         *
         * If the job runs on Amazon EKS resources, then you must not specify `platformCapabilities`.
         */
        public var platformCapabilities: List<PlatformCapability>? = null
        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state.
         *
         * If the job runs on Amazon EKS resources, then you must not specify `propagateTags`.
         */
        public var propagateTags: kotlin.Boolean? = null
        /**
         * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that's specified during a SubmitJob operation overrides the retry strategy defined here. If a job is terminated due to a timeout, it isn't retried.
         */
        public var retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = null
        /**
         * The scheduling priority for jobs that are submitted with this job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
         *
         * The minimum supported value is 0 and the maximum supported value is 9999.
         */
        public var schedulingPriority: kotlin.Int? = null
        /**
         * The tags that you apply to the job definition to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html) in *Batch User Guide*.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timeout configuration for jobs that are submitted with this job definition, after which Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds. Any timeout configuration that's specified during a SubmitJob operation overrides the timeout configuration defined here. For more information, see [Job Timeouts](https://docs.aws.amazon.com/batch/latest/userguide/job_timeouts.html) in the *Batch User Guide*.
         */
        public var timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = null
        /**
         * The type of job definition. For more information about multi-node parallel jobs, see [Creating a multi-node parallel job definition](https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html) in the *Batch User Guide*.
         *
         * If the job is run on Fargate resources, then `multinode` isn't supported.
         */
        public var type: aws.sdk.kotlin.services.batch.model.JobDefinitionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.RegisterJobDefinitionRequest) : this() {
            this.containerProperties = x.containerProperties
            this.eksProperties = x.eksProperties
            this.jobDefinitionName = x.jobDefinitionName
            this.nodeProperties = x.nodeProperties
            this.parameters = x.parameters
            this.platformCapabilities = x.platformCapabilities
            this.propagateTags = x.propagateTags
            this.retryStrategy = x.retryStrategy
            this.schedulingPriority = x.schedulingPriority
            this.tags = x.tags
            this.timeout = x.timeout
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.RegisterJobDefinitionRequest = RegisterJobDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ContainerProperties] inside the given [block]
         */
        public fun containerProperties(block: aws.sdk.kotlin.services.batch.model.ContainerProperties.Builder.() -> kotlin.Unit) {
            this.containerProperties = aws.sdk.kotlin.services.batch.model.ContainerProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EksProperties] inside the given [block]
         */
        public fun eksProperties(block: aws.sdk.kotlin.services.batch.model.EksProperties.Builder.() -> kotlin.Unit) {
            this.eksProperties = aws.sdk.kotlin.services.batch.model.EksProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NodeProperties] inside the given [block]
         */
        public fun nodeProperties(block: aws.sdk.kotlin.services.batch.model.NodeProperties.Builder.() -> kotlin.Unit) {
            this.nodeProperties = aws.sdk.kotlin.services.batch.model.NodeProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.RetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.batch.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.batch.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.JobTimeout] inside the given [block]
         */
        public fun timeout(block: aws.sdk.kotlin.services.batch.model.JobTimeout.Builder.() -> kotlin.Unit) {
            this.timeout = aws.sdk.kotlin.services.batch.model.JobTimeout.invoke(block)
        }
    }
}
