// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The retry strategy that's associated with a job. For more information, see [Automated job retries](https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html) in the *Batch User Guide*.
 */
public class RetryStrategy private constructor(builder: Builder) {
    /**
     * The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
     */
    public val attempts: kotlin.Int? = builder.attempts
    /**
     * Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
     */
    public val evaluateOnExit: List<EvaluateOnExit>? = builder.evaluateOnExit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.RetryStrategy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetryStrategy(")
        append("attempts=$attempts,")
        append("evaluateOnExit=$evaluateOnExit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attempts ?: 0
        result = 31 * result + (evaluateOnExit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetryStrategy

        if (attempts != other.attempts) return false
        if (evaluateOnExit != other.evaluateOnExit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.RetryStrategy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of times to move a job to the `RUNNABLE` status. You can specify between 1 and 10 attempts. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
         */
        public var attempts: kotlin.Int? = null
        /**
         * Array of up to 5 objects that specify the conditions where jobs are retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. If none of the listed conditions match, then the job is retried.
         */
        public var evaluateOnExit: List<EvaluateOnExit>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.RetryStrategy) : this() {
            this.attempts = x.attempts
            this.evaluateOnExit = x.evaluateOnExit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.RetryStrategy = RetryStrategy(this)
    }
}
