// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents the secret to expose to your container. Secrets can be exposed to a container in the following ways:
 * + To inject sensitive data into your containers as environment variables, use the `secrets` container definition parameter.
 * + To reference sensitive information in the log configuration of a container, use the `secretOptions` container definition parameter.
 *
 * For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *Batch User Guide*.
 */
public class Secret private constructor(builder: Builder) {
    /**
     * The name of the secret.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.
     *
     * If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
     */
    public val valueFrom: kotlin.String? = builder.valueFrom

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.Secret = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Secret(")
        append("name=$name,")
        append("valueFrom=$valueFrom)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (valueFrom?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Secret

        if (name != other.name) return false
        if (valueFrom != other.valueFrom) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.Secret = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the secret.
         */
        public var name: kotlin.String? = null
        /**
         * The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.
         *
         * If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         */
        public var valueFrom: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.Secret) : this() {
            this.name = x.name
            this.valueFrom = x.valueFrom
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.Secret = Secret(this)
    }
}
