// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `UpdateJobQueue`.
 */
public class UpdateJobQueueRequest private constructor(builder: Builder) {
    /**
     * Details the set of compute environments mapped to a job queue and their order relative to each other. This is one of the parameters used by the job scheduler to determine which compute environment runs a given job. Compute environments must be in the `VALID` state before you can associate them with a job queue. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`). EC2 and Fargate compute environments can't be mixed.
     *
     * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue.
     */
    public val computeEnvironmentOrder: List<ComputeEnvironmentOrder>? = builder.computeEnvironmentOrder
    /**
     * The name or the Amazon Resource Name (ARN) of the job queue.
     */
    public val jobQueue: kotlin.String? = builder.jobQueue
    /**
     * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1`. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`). EC2 and Fargate compute environments can't be mixed.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair share scheduling policy can be replaced but not removed. The format is `aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> `. For example, `aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy`.
     */
    public val schedulingPolicyArn: kotlin.String? = builder.schedulingPolicyArn
    /**
     * Describes the queue's ability to accept new jobs. If the job queue state is `ENABLED`, it can accept jobs. If the job queue state is `DISABLED`, new jobs can't be added to the queue, but jobs already in the queue can finish.
     */
    public val state: aws.sdk.kotlin.services.batch.model.JqState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.UpdateJobQueueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateJobQueueRequest(")
        append("computeEnvironmentOrder=$computeEnvironmentOrder,")
        append("jobQueue=$jobQueue,")
        append("priority=$priority,")
        append("schedulingPolicyArn=$schedulingPolicyArn,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironmentOrder?.hashCode() ?: 0
        result = 31 * result + (jobQueue?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (schedulingPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateJobQueueRequest

        if (computeEnvironmentOrder != other.computeEnvironmentOrder) return false
        if (jobQueue != other.jobQueue) return false
        if (priority != other.priority) return false
        if (schedulingPolicyArn != other.schedulingPolicyArn) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.UpdateJobQueueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is one of the parameters used by the job scheduler to determine which compute environment runs a given job. Compute environments must be in the `VALID` state before you can associate them with a job queue. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`). EC2 and Fargate compute environments can't be mixed.
         *
         * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue.
         */
        public var computeEnvironmentOrder: List<ComputeEnvironmentOrder>? = null
        /**
         * The name or the Amazon Resource Name (ARN) of the job queue.
         */
        public var jobQueue: kotlin.String? = null
        /**
         * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1`. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`). EC2 and Fargate compute environments can't be mixed.
         */
        public var priority: kotlin.Int? = null
        /**
         * Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair share scheduling policy can be replaced but not removed. The format is `aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> `. For example, `aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy`.
         */
        public var schedulingPolicyArn: kotlin.String? = null
        /**
         * Describes the queue's ability to accept new jobs. If the job queue state is `ENABLED`, it can accept jobs. If the job queue state is `DISABLED`, new jobs can't be added to the queue, but jobs already in the queue can finish.
         */
        public var state: aws.sdk.kotlin.services.batch.model.JqState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.UpdateJobQueueRequest) : this() {
            this.computeEnvironmentOrder = x.computeEnvironmentOrder
            this.jobQueue = x.jobQueue
            this.priority = x.priority
            this.schedulingPolicyArn = x.schedulingPolicyArn
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.UpdateJobQueueRequest = UpdateJobQueueRequest(this)
    }
}
