// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Specifies the infrastructure update policy for the compute environment. For more information about infrastructure updates, see [Infrastructure updates](https://docs.aws.amazon.com/batch/latest/userguide/infrastructure-updates.html) in the *Batch User Guide*.
 */
public class UpdatePolicy private constructor(builder: Builder) {
    /**
     * Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
     */
    public val jobExecutionTimeoutMinutes: kotlin.Long = builder.jobExecutionTimeoutMinutes
    /**
     * Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated. The default value is `false`.
     */
    public val terminateJobsOnUpdate: kotlin.Boolean? = builder.terminateJobsOnUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.UpdatePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePolicy(")
        append("jobExecutionTimeoutMinutes=$jobExecutionTimeoutMinutes,")
        append("terminateJobsOnUpdate=$terminateJobsOnUpdate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobExecutionTimeoutMinutes.hashCode()
        result = 31 * result + (terminateJobsOnUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePolicy

        if (jobExecutionTimeoutMinutes != other.jobExecutionTimeoutMinutes) return false
        if (terminateJobsOnUpdate != other.terminateJobsOnUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.UpdatePolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value is 30.
         */
        public var jobExecutionTimeoutMinutes: kotlin.Long = 0L
        /**
         * Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated. The default value is `false`.
         */
        public var terminateJobsOnUpdate: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.UpdatePolicy) : this() {
            this.jobExecutionTimeoutMinutes = x.jobExecutionTimeoutMinutes
            this.terminateJobsOnUpdate = x.terminateJobsOnUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.UpdatePolicy = UpdatePolicy(this)
    }
}
