// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * A data volume that's used in a job's container properties.
 */
public class Volume private constructor(builder: Builder) {
    /**
     * This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0`.
     */
    public val efsVolumeConfiguration: aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration? = builder.efsVolumeConfiguration
    /**
     * The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
     */
    public val host: aws.sdk.kotlin.services.batch.model.Host? = builder.host
    /**
     * The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints`.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.Volume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Volume(")
        append("efsVolumeConfiguration=$efsVolumeConfiguration,")
        append("host=$host,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = efsVolumeConfiguration?.hashCode() ?: 0
        result = 31 * result + (host?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Volume

        if (efsVolumeConfiguration != other.efsVolumeConfiguration) return false
        if (host != other.host) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.Volume = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This parameter is specified when you're using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a `platformVersion` of at least `1.4.0`.
         */
        public var efsVolumeConfiguration: aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration? = null
        /**
         * The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         */
        public var host: aws.sdk.kotlin.services.batch.model.Host? = null
        /**
         * The name of the volume. It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the `sourceVolume` parameter of container definition `mountPoints`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.Volume) : this() {
            this.efsVolumeConfiguration = x.efsVolumeConfiguration
            this.host = x.host
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.Volume = Volume(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration] inside the given [block]
         */
        public fun efsVolumeConfiguration(block: aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.efsVolumeConfiguration = aws.sdk.kotlin.services.batch.model.EfsVolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.Host] inside the given [block]
         */
        public fun host(block: aws.sdk.kotlin.services.batch.model.Host.Builder.() -> kotlin.Unit) {
            this.host = aws.sdk.kotlin.services.batch.model.Host.invoke(block)
        }
    }
}
