// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.batch.model.BatchException
import aws.sdk.kotlin.services.batch.model.CreateComputeEnvironmentResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateComputeEnvironmentOperationDeserializer: HttpDeserialize<CreateComputeEnvironmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateComputeEnvironmentResponse {
        if (!response.status.isSuccess()) {
            throwCreateComputeEnvironmentError(context, response)
        }
        val builder = CreateComputeEnvironmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateComputeEnvironmentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateComputeEnvironmentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BatchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateComputeEnvironmentOperationBody(builder: CreateComputeEnvironmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPUTEENVIRONMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computeEnvironmentArn"))
    val COMPUTEENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computeEnvironmentName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPUTEENVIRONMENTARN_DESCRIPTOR)
        field(COMPUTEENVIRONMENTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPUTEENVIRONMENTARN_DESCRIPTOR.index -> builder.computeEnvironmentArn = deserializeString()
                COMPUTEENVIRONMENTNAME_DESCRIPTOR.index -> builder.computeEnvironmentName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
