// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.batch.model.BatchException
import aws.sdk.kotlin.services.batch.model.CreateJobQueueResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateJobQueueOperationDeserializer: HttpDeserialize<CreateJobQueueResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateJobQueueResponse {
        if (!response.status.isSuccess()) {
            throwCreateJobQueueError(context, response)
        }
        val builder = CreateJobQueueResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateJobQueueOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateJobQueueError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BatchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateJobQueueOperationBody(builder: CreateJobQueueResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOBQUEUEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobQueueArn"))
    val JOBQUEUENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobQueueName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOBQUEUEARN_DESCRIPTOR)
        field(JOBQUEUENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOBQUEUEARN_DESCRIPTOR.index -> builder.jobQueueArn = deserializeString()
                JOBQUEUENAME_DESCRIPTOR.index -> builder.jobQueueName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
