// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.batch.model.BatchException
import aws.sdk.kotlin.services.batch.model.DescribeSchedulingPoliciesResponse
import aws.sdk.kotlin.services.batch.model.SchedulingPolicyDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSchedulingPoliciesOperationDeserializer: HttpDeserialize<DescribeSchedulingPoliciesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSchedulingPoliciesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSchedulingPoliciesError(context, response)
        }
        val builder = DescribeSchedulingPoliciesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSchedulingPoliciesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSchedulingPoliciesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BatchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSchedulingPoliciesOperationBody(builder: DescribeSchedulingPoliciesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SCHEDULINGPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("schedulingPolicies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SCHEDULINGPOLICIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SCHEDULINGPOLICIES_DESCRIPTOR.index -> builder.schedulingPolicies =
                    deserializer.deserializeList(SCHEDULINGPOLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<SchedulingPolicyDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSchedulingPolicyDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
