// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.transform

import aws.sdk.kotlin.services.batch.model.ContainerProperties
import aws.sdk.kotlin.services.batch.model.EksProperties
import aws.sdk.kotlin.services.batch.model.JobDefinitionType
import aws.sdk.kotlin.services.batch.model.JobTimeout
import aws.sdk.kotlin.services.batch.model.NodeProperties
import aws.sdk.kotlin.services.batch.model.PlatformCapability
import aws.sdk.kotlin.services.batch.model.RegisterJobDefinitionRequest
import aws.sdk.kotlin.services.batch.model.RetryStrategy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterJobDefinitionOperationSerializer: HttpSerialize<RegisterJobDefinitionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RegisterJobDefinitionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/v1/registerjobdefinition"
        }

        val payload = serializeRegisterJobDefinitionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRegisterJobDefinitionOperationBody(context: ExecutionContext, input: RegisterJobDefinitionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTAINERPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("containerProperties"))
    val EKSPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("eksProperties"))
    val JOBDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobDefinitionName"))
    val NODEPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("nodeProperties"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("parameters"))
    val PLATFORMCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("platformCapabilities"))
    val PROPAGATETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("propagateTags"))
    val RETRYSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("retryStrategy"))
    val SCHEDULINGPRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("schedulingPriority"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timeout"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTAINERPROPERTIES_DESCRIPTOR)
        field(EKSPROPERTIES_DESCRIPTOR)
        field(JOBDEFINITIONNAME_DESCRIPTOR)
        field(NODEPROPERTIES_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PLATFORMCAPABILITIES_DESCRIPTOR)
        field(PROPAGATETAGS_DESCRIPTOR)
        field(RETRYSTRATEGY_DESCRIPTOR)
        field(SCHEDULINGPRIORITY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEOUT_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.containerProperties?.let { field(CONTAINERPROPERTIES_DESCRIPTOR, it, ::serializeContainerPropertiesDocument) }
        input.eksProperties?.let { field(EKSPROPERTIES_DESCRIPTOR, it, ::serializeEksPropertiesDocument) }
        input.jobDefinitionName?.let { field(JOBDEFINITIONNAME_DESCRIPTOR, it) }
        input.nodeProperties?.let { field(NODEPROPERTIES_DESCRIPTOR, it, ::serializeNodePropertiesDocument) }
        if (input.parameters != null) {
            mapField(PARAMETERS_DESCRIPTOR) {
                input.parameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.platformCapabilities != null) {
            listField(PLATFORMCAPABILITIES_DESCRIPTOR) {
                for (el0 in input.platformCapabilities) {
                    serializeString(el0.value)
                }
            }
        }
        input.propagateTags?.let { field(PROPAGATETAGS_DESCRIPTOR, it) }
        input.retryStrategy?.let { field(RETRYSTRATEGY_DESCRIPTOR, it, ::serializeRetryStrategyDocument) }
        input.schedulingPriority?.let { field(SCHEDULINGPRIORITY_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.timeout?.let { field(TIMEOUT_DESCRIPTOR, it, ::serializeJobTimeoutDocument) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
