// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The order in which compute environments are tried for job placement within a queue. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first. Compute environments must be in the `VALID` state before you can associate them with a job queue. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
 *
 * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue.
 */
public class ComputeEnvironmentOrder private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the compute environment.
     */
    public val computeEnvironment: kotlin.String? = builder.computeEnvironment
    /**
     * The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
     */
    public val order: kotlin.Int? = builder.order

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ComputeEnvironmentOrder = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeEnvironmentOrder(")
        append("computeEnvironment=$computeEnvironment,")
        append("order=$order)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironment?.hashCode() ?: 0
        result = 31 * result + (order ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeEnvironmentOrder

        if (computeEnvironment != other.computeEnvironment) return false
        if (order != other.order) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ComputeEnvironmentOrder = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the compute environment.
         */
        public var computeEnvironment: kotlin.String? = null
        /**
         * The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower `order` integer value is tried for job placement first.
         */
        public var order: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ComputeEnvironmentOrder) : this() {
            this.computeEnvironment = x.computeEnvironment
            this.order = x.order
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ComputeEnvironmentOrder = ComputeEnvironmentOrder(this)
    }
}
