// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object representing an Batch compute resource. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
 */
public class ComputeResource private constructor(builder: Builder) {
    /**
     * The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html). For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * ## BEST_FIT (default)
     * Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM Role must be specified. Compute resources that use a `BEST_FIT` allocation strategy don't support infrastructure updates and can't update some parameters. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * ## BEST_FIT_PROGRESSIVE
     * Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, Batch will select new instance types.
     *
     * ## SPOT_CAPACITY_OPTIMIZED
     * Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
     *
     * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` strategies, Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance.
     */
    public val allocationStrategy: aws.sdk.kotlin.services.batch.model.CrAllocationStrategy? = builder.allocationStrategy
    /**
     * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. If you leave this field empty, the default value is 100% of the On-Demand price.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val bidPercentage: kotlin.Int? = builder.bidPercentage
    /**
     * The desired number of Amazon EC2 vCPUS in the compute environment. Batch modifies this value between the minimum and maximum values, based on job queue demand.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val desiredvCpus: kotlin.Int? = builder.desiredvCpus
    /**
     * Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2`.
     *
     * One or two values can be provided.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val ec2Configuration: List<Ec2Configuration>? = builder.ec2Configuration
    /**
     * The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val ec2KeyPair: kotlin.String? = builder.ec2KeyPair
    /**
     * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, ` <i>ecsInstanceRole</i> ` or `arn:aws:iam::<i><aws_account_id></i>:instance-profile/<i>ecsInstanceRole</i> `. For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val instanceRole: kotlin.String? = builder.instanceRole
    /**
     * The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3`), or you can specify specific sizes within a family (such as `c5.8xlarge`). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment.
     *
     * Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The launch template to use for your compute resources. Any other compute resource parameters that you specify in a CreateComputeEnvironment API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch template support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val launchTemplate: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The maximum number of Amazon EC2 vCPUs that a compute environment can reach.
     *
     * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` allocation strategies, Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance. For example, no more than a single instance from among those specified in your compute environment is allocated.
     */
    public val maxvCpus: kotlin.Int? = builder.maxvCpus
    /**
     * The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is `DISABLED`).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val minvCpus: kotlin.Int? = builder.minvCpus
    /**
     * The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val placementGroup: kotlin.String? = builder.placementGroup
    /**
     * The Amazon EC2 security groups associated with instances launched in the compute environment. One or more security groups must be specified, either in `securityGroupIds` or using a launch template referenced in `launchTemplate`. This parameter is required for jobs that are running on Fargate resources and must contain at least one security group. Fargate doesn't support launch templates. If security groups are specified using both `securityGroupIds` and `launchTemplate`, the values in `securityGroupIds` are used.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer **AmazonEC2SpotFleetTaggingRole** managed policy. The previously recommended **AmazonEC2SpotFleetRole** managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *Batch User Guide*.
     */
    public val spotIamFleetRole: kotlin.String? = builder.spotIamFleetRole
    /**
     * The VPC subnets where the compute resources are launched. These subnets must be within the same VPC. Fargate compute resources can contain up to 16 subnets. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide*.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * Key-value pair tags to be applied to EC2 resources that are launched in the compute environment. For Batch, these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, `{ "Name": "Batch Instance - C4OnDemand" }`. This is helpful for recognizing your Batch instances in the Amazon EC2 console. Updating these tags requires an infrastructure update to the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*. These tags aren't seen when using the Batch `ListTagsForResource` API operation.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of compute environment: `EC2`, `SPOT`, `FARGATE`, or `FARGATE_SPOT`. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     *
     *  If you choose `SPOT`, you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *Batch User Guide*.
     */
    public val type: aws.sdk.kotlin.services.batch.model.CrType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ComputeResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeResource(")
        append("allocationStrategy=$allocationStrategy,")
        append("bidPercentage=$bidPercentage,")
        append("desiredvCpus=$desiredvCpus,")
        append("ec2Configuration=$ec2Configuration,")
        append("ec2KeyPair=$ec2KeyPair,")
        append("imageId=$imageId,")
        append("instanceRole=$instanceRole,")
        append("instanceTypes=$instanceTypes,")
        append("launchTemplate=$launchTemplate,")
        append("maxvCpus=$maxvCpus,")
        append("minvCpus=$minvCpus,")
        append("placementGroup=$placementGroup,")
        append("securityGroupIds=$securityGroupIds,")
        append("spotIamFleetRole=$spotIamFleetRole,")
        append("subnets=$subnets,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (bidPercentage ?: 0)
        result = 31 * result + (desiredvCpus ?: 0)
        result = 31 * result + (ec2Configuration?.hashCode() ?: 0)
        result = 31 * result + (ec2KeyPair?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceRole?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (maxvCpus ?: 0)
        result = 31 * result + (minvCpus ?: 0)
        result = 31 * result + (placementGroup?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (spotIamFleetRole?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeResource

        if (allocationStrategy != other.allocationStrategy) return false
        if (bidPercentage != other.bidPercentage) return false
        if (desiredvCpus != other.desiredvCpus) return false
        if (ec2Configuration != other.ec2Configuration) return false
        if (ec2KeyPair != other.ec2KeyPair) return false
        if (imageId != other.imageId) return false
        if (instanceRole != other.instanceRole) return false
        if (instanceTypes != other.instanceTypes) return false
        if (launchTemplate != other.launchTemplate) return false
        if (maxvCpus != other.maxvCpus) return false
        if (minvCpus != other.minvCpus) return false
        if (placementGroup != other.placementGroup) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (spotIamFleetRole != other.spotIamFleetRole) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ComputeResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html). For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * ## BEST_FIT (default)
         * Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html) then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with `BEST_FIT` then the Spot Fleet IAM Role must be specified. Compute resources that use a `BEST_FIT` allocation strategy don't support infrastructure updates and can't update some parameters. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * ## BEST_FIT_PROGRESSIVE
         * Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, Batch will select new instance types.
         *
         * ## SPOT_CAPACITY_OPTIMIZED
         * Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
         *
         * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` strategies, Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance.
         */
        public var allocationStrategy: aws.sdk.kotlin.services.batch.model.CrAllocationStrategy? = null
        /**
         * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. If you leave this field empty, the default value is 100% of the On-Demand price.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var bidPercentage: kotlin.Int? = null
        /**
         * The desired number of Amazon EC2 vCPUS in the compute environment. Batch modifies this value between the minimum and maximum values, based on job queue demand.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var desiredvCpus: kotlin.Int? = null
        /**
         * Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2`.
         *
         * One or two values can be provided.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var ec2Configuration: List<Ec2Configuration>? = null
        /**
         * The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var ec2KeyPair: kotlin.String? = null
        /**
         * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var imageId: kotlin.String? = null
        /**
         * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, ` <i>ecsInstanceRole</i> ` or `arn:aws:iam::<i><aws_account_id></i>:instance-profile/<i>ecsInstanceRole</i> `. For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var instanceRole: kotlin.String? = null
        /**
         * The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3`), or you can specify specific sizes within a family (such as `c5.8xlarge`). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment.
         *
         * Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The launch template to use for your compute resources. Any other compute resource parameters that you specify in a CreateComputeEnvironment API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch template support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var launchTemplate: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification? = null
        /**
         * The maximum number of Amazon EC2 vCPUs that a compute environment can reach.
         *
         * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` allocation strategies, Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance. For example, no more than a single instance from among those specified in your compute environment is allocated.
         */
        public var maxvCpus: kotlin.Int? = null
        /**
         * The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is `DISABLED`).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var minvCpus: kotlin.Int? = null
        /**
         * The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var placementGroup: kotlin.String? = null
        /**
         * The Amazon EC2 security groups associated with instances launched in the compute environment. One or more security groups must be specified, either in `securityGroupIds` or using a launch template referenced in `launchTemplate`. This parameter is required for jobs that are running on Fargate resources and must contain at least one security group. Fargate doesn't support launch templates. If security groups are specified using both `securityGroupIds` and `launchTemplate`, the values in `securityGroupIds` are used.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment. This role is required if the allocation strategy set to `BEST_FIT` or if the allocation strategy isn't specified. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer **AmazonEC2SpotFleetTaggingRole** managed policy. The previously recommended **AmazonEC2SpotFleetRole** managed policy doesn't have the required permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag) in the *Batch User Guide*.
         */
        public var spotIamFleetRole: kotlin.String? = null
        /**
         * The VPC subnets where the compute resources are launched. These subnets must be within the same VPC. Fargate compute resources can contain up to 16 subnets. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide*.
         */
        public var subnets: List<String>? = null
        /**
         * Key-value pair tags to be applied to EC2 resources that are launched in the compute environment. For Batch, these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, `{ "Name": "Batch Instance - C4OnDemand" }`. This is helpful for recognizing your Batch instances in the Amazon EC2 console. Updating these tags requires an infrastructure update to the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*. These tags aren't seen when using the Batch `ListTagsForResource` API operation.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of compute environment: `EC2`, `SPOT`, `FARGATE`, or `FARGATE_SPOT`. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         *
         *  If you choose `SPOT`, you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *Batch User Guide*.
         */
        public var type: aws.sdk.kotlin.services.batch.model.CrType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ComputeResource) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.bidPercentage = x.bidPercentage
            this.desiredvCpus = x.desiredvCpus
            this.ec2Configuration = x.ec2Configuration
            this.ec2KeyPair = x.ec2KeyPair
            this.imageId = x.imageId
            this.instanceRole = x.instanceRole
            this.instanceTypes = x.instanceTypes
            this.launchTemplate = x.launchTemplate
            this.maxvCpus = x.maxvCpus
            this.minvCpus = x.minvCpus
            this.placementGroup = x.placementGroup
            this.securityGroupIds = x.securityGroupIds
            this.spotIamFleetRole = x.spotIamFleetRole
            this.subnets = x.subnets
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ComputeResource = ComputeResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification.invoke(block)
        }
    }
}
