// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object representing the attributes of a compute environment that can be updated. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
 */
public class ComputeResourceUpdate private constructor(builder: Builder) {
    /**
     * The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html). For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *Batch User Guide*.
     *
     * When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*. `BEST_FIT` isn't supported when updating a compute environment.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * ## BEST_FIT_PROGRESSIVE
     * Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, Batch will select new instance types.
     *
     * ## SPOT_CAPACITY_OPTIMIZED
     * Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
     *
     * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` strategies, Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance.
     */
    public val allocationStrategy: aws.sdk.kotlin.services.batch.model.CrUpdateAllocationStrategy? = builder.allocationStrategy
    /**
     * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage.
     *
     * When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val bidPercentage: kotlin.Int? = builder.bidPercentage
    /**
     * The desired number of Amazon EC2 vCPUS in the compute environment. Batch modifies this value between the minimum and maximum values based on job queue demand.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val desiredvCpus: kotlin.Int? = builder.desiredvCpus
    /**
     * Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2`.
     *
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*. To remove the EC2 configuration and any custom AMI ID specified in `imageIdOverride`, set this value to an empty string.
     *
     * One or two values can be provided.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val ec2Configuration: List<Ec2Configuration>? = builder.ec2Configuration
    /**
     * The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
     *
     * When updating a compute environment, changing the EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val ec2KeyPair: kotlin.String? = builder.ec2KeyPair
    /**
     * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
     *
     * When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, ` <i>ecsInstanceRole</i> ` or `arn:aws:iam::<i><aws_account_id></i>:instance-profile/<i>ecsInstanceRole</i> `. For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *Batch User Guide*.
     *
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val instanceRole: kotlin.String? = builder.instanceRole
    /**
     * The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3`), or you can specify specific sizes within a family (such as `c5.8xlarge`). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
     *
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     *
     * When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment.
     *
     * Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The updated launch template to use for your compute resources. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch template support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the *Batch User Guide*. To remove the custom launch template and use the default launch template, set `launchTemplateId` or `launchTemplateName` member of the launch template specification to an empty string. Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true`.
     *
     * When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val launchTemplate: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The maximum number of Amazon EC2 vCPUs that an environment can reach.
     *
     * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` allocation strategies, Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance. That is, no more than a single instance from among those specified in your compute environment.
     */
    public val maxvCpus: kotlin.Int? = builder.maxvCpus
    /**
     * The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is `DISABLED`).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val minvCpus: kotlin.Int? = builder.minvCpus
    /**
     * The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val placementGroup: kotlin.String? = builder.placementGroup
    /**
     * The Amazon EC2 security groups associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the security groups from the compute resource.
     *
     * When updating a compute environment, changing the EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide*.
     *
     * When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * Key-value pair tags to be applied to EC2 resources that are launched in the compute environment. For Batch, these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, `{ "Name": "Batch Instance - C4OnDemand" }`. This is helpful for recognizing your Batch instances in the Amazon EC2 console. These tags aren't seen when using the Batch `ListTagsForResource` API operation.
     *
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of compute environment: `EC2`, `SPOT`, `FARGATE`, or `FARGATE_SPOT`. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     *
     *  If you choose `SPOT`, you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *Batch User Guide*.
     *
     * When updating a compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     */
    public val type: aws.sdk.kotlin.services.batch.model.CrType? = builder.type
    /**
     * Specifies whether the AMI ID is updated to the latest one that's supported by Batch when the compute environment has an infrastructure update. The default value is `false`.
     *
     * If an AMI ID is specified in the `imageId` or `imageIdOverride` parameters or by the launch template specified in the `launchTemplate` parameter, this parameter is ignored. For more information on updating AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *Batch User Guide*.
     *
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     */
    public val updateToLatestImageVersion: kotlin.Boolean? = builder.updateToLatestImageVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeResourceUpdate(")
        append("allocationStrategy=$allocationStrategy,")
        append("bidPercentage=$bidPercentage,")
        append("desiredvCpus=$desiredvCpus,")
        append("ec2Configuration=$ec2Configuration,")
        append("ec2KeyPair=$ec2KeyPair,")
        append("imageId=$imageId,")
        append("instanceRole=$instanceRole,")
        append("instanceTypes=$instanceTypes,")
        append("launchTemplate=$launchTemplate,")
        append("maxvCpus=$maxvCpus,")
        append("minvCpus=$minvCpus,")
        append("placementGroup=$placementGroup,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets,")
        append("tags=$tags,")
        append("type=$type,")
        append("updateToLatestImageVersion=$updateToLatestImageVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (bidPercentage ?: 0)
        result = 31 * result + (desiredvCpus ?: 0)
        result = 31 * result + (ec2Configuration?.hashCode() ?: 0)
        result = 31 * result + (ec2KeyPair?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceRole?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (maxvCpus ?: 0)
        result = 31 * result + (minvCpus ?: 0)
        result = 31 * result + (placementGroup?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updateToLatestImageVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeResourceUpdate

        if (allocationStrategy != other.allocationStrategy) return false
        if (bidPercentage != other.bidPercentage) return false
        if (desiredvCpus != other.desiredvCpus) return false
        if (ec2Configuration != other.ec2Configuration) return false
        if (ec2KeyPair != other.ec2KeyPair) return false
        if (imageId != other.imageId) return false
        if (instanceRole != other.instanceRole) return false
        if (instanceTypes != other.instanceTypes) return false
        if (launchTemplate != other.launchTemplate) return false
        if (maxvCpus != other.maxvCpus) return false
        if (minvCpus != other.minvCpus) return false
        if (placementGroup != other.placementGroup) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (updateToLatestImageVersion != other.updateToLatestImageVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or [Amazon EC2 service limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html). For more information, see [Allocation strategies](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) in the *Batch User Guide*.
         *
         * When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*. `BEST_FIT` isn't supported when updating a compute environment.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * ## BEST_FIT_PROGRESSIVE
         * Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, Batch will select new instance types.
         *
         * ## SPOT_CAPACITY_OPTIMIZED
         * Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.
         *
         * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` strategies, Batch might need to go above `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance.
         */
        public var allocationStrategy: aws.sdk.kotlin.services.batch.model.CrUpdateAllocationStrategy? = null
        /**
         * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage.
         *
         * When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var bidPercentage: kotlin.Int? = null
        /**
         * The desired number of Amazon EC2 vCPUS in the compute environment. Batch modifies this value between the minimum and maximum values based on job queue demand.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var desiredvCpus: kotlin.Int? = null
        /**
         * Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If `Ec2Configuration` isn't specified, the default is `ECS_AL2`.
         *
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*. To remove the EC2 configuration and any custom AMI ID specified in `imageIdOverride`, set this value to an empty string.
         *
         * One or two values can be provided.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var ec2Configuration: List<Ec2Configuration>? = null
        /**
         * The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
         *
         * When updating a compute environment, changing the EC2 key pair requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var ec2KeyPair: kotlin.String? = null
        /**
         * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the `imageIdOverride` member of the `Ec2Configuration` structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
         *
         * When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var imageId: kotlin.String? = null
        /**
         * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, ` <i>ecsInstanceRole</i> ` or `arn:aws:iam::<i><aws_account_id></i>:instance-profile/<i>ecsInstanceRole</i> `. For more information, see [Amazon ECS instance role](https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in the *Batch User Guide*.
         *
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var instanceRole: kotlin.String? = null
        /**
         * The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, `c5` or `p3`), or you can specify specific sizes within a family (such as `c5.8xlarge`). You can also choose `optimal` to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
         *
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         *
         * When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment.
         *
         * Currently, `optimal` uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The updated launch template to use for your compute resources. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see [Launch template support](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the *Batch User Guide*. To remove the custom launch template and use the default launch template, set `launchTemplateId` or `launchTemplateName` member of the launch template specification to an empty string. Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the `updateToLatestImageVersion` parameter must be set to `true`.
         *
         * When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var launchTemplate: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification? = null
        /**
         * The maximum number of Amazon EC2 vCPUs that an environment can reach.
         *
         * With both `BEST_FIT_PROGRESSIVE` and `SPOT_CAPACITY_OPTIMIZED` allocation strategies, Batch might need to exceed `maxvCpus` to meet your capacity requirements. In this event, Batch never exceeds `maxvCpus` by more than a single instance. That is, no more than a single instance from among those specified in your compute environment.
         */
        public var maxvCpus: kotlin.Int? = null
        /**
         * The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is `DISABLED`).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var minvCpus: kotlin.Int? = null
        /**
         * The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var placementGroup: kotlin.String? = null
        /**
         * The Amazon EC2 security groups associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the security groups from the compute resource.
         *
         * When updating a compute environment, changing the EC2 security groups requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide*.
         *
         * When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         */
        public var subnets: List<String>? = null
        /**
         * Key-value pair tags to be applied to EC2 resources that are launched in the compute environment. For Batch, these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, `{ "Name": "Batch Instance - C4OnDemand" }`. This is helpful for recognizing your Batch instances in the Amazon EC2 console. These tags aren't seen when using the Batch `ListTagsForResource` API operation.
         *
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of compute environment: `EC2`, `SPOT`, `FARGATE`, or `FARGATE_SPOT`. For more information, see [Compute environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         *
         *  If you choose `SPOT`, you must also specify an Amazon EC2 Spot Fleet role with the `spotIamFleetRole` parameter. For more information, see [Amazon EC2 spot fleet role](https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in the *Batch User Guide*.
         *
         * When updating a compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         */
        public var type: aws.sdk.kotlin.services.batch.model.CrType? = null
        /**
         * Specifies whether the AMI ID is updated to the latest one that's supported by Batch when the compute environment has an infrastructure update. The default value is `false`.
         *
         * If an AMI ID is specified in the `imageId` or `imageIdOverride` parameters or by the launch template specified in the `launchTemplate` parameter, this parameter is ignored. For more information on updating AMI IDs during an infrastructure update, see [Updating the AMI ID](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami) in the *Batch User Guide*.
         *
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         */
        public var updateToLatestImageVersion: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.bidPercentage = x.bidPercentage
            this.desiredvCpus = x.desiredvCpus
            this.ec2Configuration = x.ec2Configuration
            this.ec2KeyPair = x.ec2KeyPair
            this.imageId = x.imageId
            this.instanceRole = x.instanceRole
            this.instanceTypes = x.instanceTypes
            this.launchTemplate = x.launchTemplate
            this.maxvCpus = x.maxvCpus
            this.minvCpus = x.minvCpus
            this.placementGroup = x.placementGroup
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
            this.tags = x.tags
            this.type = x.type
            this.updateToLatestImageVersion = x.updateToLatestImageVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate = ComputeResourceUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.batch.model.LaunchTemplateSpecification.invoke(block)
        }
    }
}
