// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * The overrides that should be sent to a container.
 */
public class ContainerOverrides private constructor(builder: Builder) {
    /**
     * The command to send to the container that overrides the default command from the Docker image or the job definition.
     */
    public val command: List<String>? = builder.command
    /**
     * The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the job definition.
     *
     * Environment variables must not start with `AWS_BATCH`; this naming convention is reserved for variables that are set by the Batch service.
     */
    public val environment: List<KeyValuePair>? = builder.environment
    /**
     * The instance type to use for a multi-node parallel job.
     *
     * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * This parameter is deprecated, use `resourceRequirements` to override the memory requirements specified in the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it overrides the `memory` parameter set in the job definition, but doesn't override any memory requirement specified in the `resourceRequirements` structure in the job definition. To override memory requirements that are specified in the `resourceRequirements` structure in the job definition, `resourceRequirements` must be specified in the `SubmitJob` request, with `type` set to `MEMORY` and `value` set to the new value. For more information, see [Can't override job definition resource requirements](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements) in the *Batch User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val memory: kotlin.Int? = builder.memory
    /**
     * The type and amount of resources to assign to a container. This overrides the settings in the job definition. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
     */
    public val resourceRequirements: List<ResourceRequirement>? = builder.resourceRequirements
    /**
     * This parameter is deprecated, use `resourceRequirements` to override the `vcpus` parameter that's set in the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it overrides the `vcpus` parameter set in the job definition, but doesn't override any vCPU requirement specified in the `resourceRequirements` structure in the job definition. To override vCPU requirements that are specified in the `resourceRequirements` structure in the job definition, `resourceRequirements` must be specified in the `SubmitJob` request, with `type` set to `VCPU` and `value` set to the new value. For more information, see [Can't override job definition resource requirements](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements) in the *Batch User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val vcpus: kotlin.Int? = builder.vcpus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ContainerOverrides = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerOverrides(")
        append("command=$command,")
        append("environment=$environment,")
        append("instanceType=$instanceType,")
        append("memory=$memory,")
        append("resourceRequirements=$resourceRequirements,")
        append("vcpus=$vcpus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (resourceRequirements?.hashCode() ?: 0)
        result = 31 * result + (vcpus ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerOverrides

        if (command != other.command) return false
        if (environment != other.environment) return false
        if (instanceType != other.instanceType) return false
        if (memory != other.memory) return false
        if (resourceRequirements != other.resourceRequirements) return false
        if (vcpus != other.vcpus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ContainerOverrides = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The command to send to the container that overrides the default command from the Docker image or the job definition.
         */
        public var command: List<String>? = null
        /**
         * The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the job definition.
         *
         * Environment variables must not start with `AWS_BATCH`; this naming convention is reserved for variables that are set by the Batch service.
         */
        public var environment: List<KeyValuePair>? = null
        /**
         * The instance type to use for a multi-node parallel job.
         *
         * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
         */
        public var instanceType: kotlin.String? = null
        /**
         * This parameter is deprecated, use `resourceRequirements` to override the memory requirements specified in the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it overrides the `memory` parameter set in the job definition, but doesn't override any memory requirement specified in the `resourceRequirements` structure in the job definition. To override memory requirements that are specified in the `resourceRequirements` structure in the job definition, `resourceRequirements` must be specified in the `SubmitJob` request, with `type` set to `MEMORY` and `value` set to the new value. For more information, see [Can't override job definition resource requirements](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements) in the *Batch User Guide*.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var memory: kotlin.Int? = null
        /**
         * The type and amount of resources to assign to a container. This overrides the settings in the job definition. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
         */
        public var resourceRequirements: List<ResourceRequirement>? = null
        /**
         * This parameter is deprecated, use `resourceRequirements` to override the `vcpus` parameter that's set in the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it overrides the `vcpus` parameter set in the job definition, but doesn't override any vCPU requirement specified in the `resourceRequirements` structure in the job definition. To override vCPU requirements that are specified in the `resourceRequirements` structure in the job definition, `resourceRequirements` must be specified in the `SubmitJob` request, with `type` set to `VCPU` and `value` set to the new value. For more information, see [Can't override job definition resource requirements](https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements) in the *Batch User Guide*.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var vcpus: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ContainerOverrides) : this() {
            this.command = x.command
            this.environment = x.environment
            this.instanceType = x.instanceType
            this.memory = x.memory
            this.resourceRequirements = x.resourceRequirements
            this.vcpus = x.vcpus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ContainerOverrides = ContainerOverrides(this)
    }
}
