// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Container properties are used in job definitions to describe the container that's launched as part of a job.
 */
public class ContainerProperties private constructor(builder: Builder) {
    /**
     * The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.docker.com/engine/reference/run/). For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.docker.com/engine/reference/builder/#cmd).
     */
    public val command: List<String>? = builder.command
    /**
     * The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
     *
     * Environment variables must not start with `AWS_BATCH`; this naming convention is reserved for variables that are set by the Batch service.
     */
    public val environment: List<KeyValuePair>? = builder.environment
    /**
     * The Amazon Resource Name (ARN) of the execution role that Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *Batch User Guide*.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
     */
    public val fargatePlatformConfiguration: aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration? = builder.fargatePlatformConfiguration
    /**
     * The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with ` <i>repository-url</i>/<i>image</i>:<i>tag</i> `. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
     *
     * + Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/<i>registry_alias</i>/<i>my-web-app</i>:<i>latest</i> `.
     * + Images in Amazon ECR repositories use the full registry and repository URI (for example, `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>`).
     * + Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo`).
     * + Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent`).
     * + Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu`).
     */
    public val image: kotlin.String? = builder.image
    /**
     * The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.
     *
     * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val jobRoleArn: kotlin.String? = builder.jobRoleArn
    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     */
    public val linuxParameters: aws.sdk.kotlin.services.batch.model.LinuxParameters? = builder.linuxParameters
    /**
     * The log configuration specification for the container.
     *
     * This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.docker.com/engine/reference/run/). By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
     *
     * Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the LogConfiguration data type).
     *
     * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: `sudo docker version | grep "Server API version"`
     *
     * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val logConfiguration: aws.sdk.kotlin.services.batch.model.LogConfiguration? = builder.logConfiguration
    /**
     * This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val memory: kotlin.Int? = builder.memory
    /**
     * The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.docker.com/engine/reference/run/).
     */
    public val mountPoints: List<MountPoint>? = builder.mountPoints
    /**
     * The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.batch.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.docker.com/engine/reference/run/). The default value is false.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
     */
    public val privileged: kotlin.Boolean? = builder.privileged
    /**
     * When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run`.
     */
    public val readonlyRootFilesystem: kotlin.Boolean? = builder.readonlyRootFilesystem
    /**
     * The type and amount of resources to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
     */
    public val resourceRequirements: List<ResourceRequirement>? = builder.resourceRequirements
    /**
     * The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *Batch User Guide*.
     */
    public val secrets: List<Secret>? = builder.secrets
    /**
     * A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.docker.com/engine/reference/run/).
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
     */
    public val ulimits: List<Ulimit>? = builder.ulimits
    /**
     * The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.docker.com/engine/reference/run/).
     */
    public val user: kotlin.String? = builder.user
    /**
     * This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the number of vCPUs reserved for the job.
     *
     * Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.docker.com/engine/reference/run/). The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val vcpus: kotlin.Int? = builder.vcpus
    /**
     * A list of data volumes used in a job.
     */
    public val volumes: List<Volume>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ContainerProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerProperties(")
        append("command=$command,")
        append("environment=$environment,")
        append("executionRoleArn=$executionRoleArn,")
        append("fargatePlatformConfiguration=$fargatePlatformConfiguration,")
        append("image=$image,")
        append("instanceType=$instanceType,")
        append("jobRoleArn=$jobRoleArn,")
        append("linuxParameters=$linuxParameters,")
        append("logConfiguration=$logConfiguration,")
        append("memory=$memory,")
        append("mountPoints=$mountPoints,")
        append("networkConfiguration=$networkConfiguration,")
        append("privileged=$privileged,")
        append("readonlyRootFilesystem=$readonlyRootFilesystem,")
        append("resourceRequirements=$resourceRequirements,")
        append("secrets=$secrets,")
        append("ulimits=$ulimits,")
        append("user=$user,")
        append("vcpus=$vcpus,")
        append("volumes=$volumes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (fargatePlatformConfiguration?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (jobRoleArn?.hashCode() ?: 0)
        result = 31 * result + (linuxParameters?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (mountPoints?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (privileged?.hashCode() ?: 0)
        result = 31 * result + (readonlyRootFilesystem?.hashCode() ?: 0)
        result = 31 * result + (resourceRequirements?.hashCode() ?: 0)
        result = 31 * result + (secrets?.hashCode() ?: 0)
        result = 31 * result + (ulimits?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        result = 31 * result + (vcpus ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerProperties

        if (command != other.command) return false
        if (environment != other.environment) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (fargatePlatformConfiguration != other.fargatePlatformConfiguration) return false
        if (image != other.image) return false
        if (instanceType != other.instanceType) return false
        if (jobRoleArn != other.jobRoleArn) return false
        if (linuxParameters != other.linuxParameters) return false
        if (logConfiguration != other.logConfiguration) return false
        if (memory != other.memory) return false
        if (mountPoints != other.mountPoints) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (privileged != other.privileged) return false
        if (readonlyRootFilesystem != other.readonlyRootFilesystem) return false
        if (resourceRequirements != other.resourceRequirements) return false
        if (secrets != other.secrets) return false
        if (ulimits != other.ulimits) return false
        if (user != other.user) return false
        if (vcpus != other.vcpus) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ContainerProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The command that's passed to the container. This parameter maps to `Cmd` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `COMMAND` parameter to [docker run](https://docs.docker.com/engine/reference/run/). For more information, see [https://docs.docker.com/engine/reference/builder/#cmd](https://docs.docker.com/engine/reference/builder/#cmd).
         */
        public var command: List<String>? = null
        /**
         * The environment variables to pass to a container. This parameter maps to `Env` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--env` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         *
         * Environment variables must not start with `AWS_BATCH`; this naming convention is reserved for variables that are set by the Batch service.
         */
        public var environment: List<KeyValuePair>? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role that Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see [Batch execution IAM role](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in the *Batch User Guide*.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
         */
        public var fargatePlatformConfiguration: aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration? = null
        /**
         * The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with ` <i>repository-url</i>/<i>image</i>:<i>tag</i> `. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to `Image` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `IMAGE` parameter of [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
         *
         * + Images in Amazon ECR Public repositories use the full `registry/repository[:tag]` or `registry/repository[@digest]` naming conventions. For example, `public.ecr.aws/<i>registry_alias</i>/<i>my-web-app</i>:<i>latest</i> `.
         * + Images in Amazon ECR repositories use the full registry and repository URI (for example, `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>`).
         * + Images in official repositories on Docker Hub use a single name (for example, `ubuntu` or `mongo`).
         * + Images in other repositories on Docker Hub are qualified with an organization name (for example, `amazon/amazon-ecs-agent`).
         * + Images in other online repositories are qualified further by a domain name (for example, `quay.io/assemblyline/ubuntu`).
         */
        public var image: kotlin.String? = null
        /**
         * The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.
         *
         * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services permissions. For more information, see [IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var jobRoleArn: kotlin.String? = null
        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         */
        public var linuxParameters: aws.sdk.kotlin.services.batch.model.LinuxParameters? = null
        /**
         * The log configuration specification for the container.
         *
         * This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--log-driver` option to [docker run](https://docs.docker.com/engine/reference/run/). By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
         *
         * Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the LogConfiguration data type).
         *
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: `sudo docker version | grep "Server API version"`
         *
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var logConfiguration: aws.sdk.kotlin.services.batch.model.LogConfiguration? = null
        /**
         * This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var memory: kotlin.Int? = null
        /**
         * The mount points for data volumes in your container. This parameter maps to `Volumes` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--volume` option to [docker run](https://docs.docker.com/engine/reference/run/).
         */
        public var mountPoints: List<MountPoint>? = null
        /**
         * The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.batch.model.NetworkConfiguration? = null
        /**
         * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user). This parameter maps to `Privileged` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--privileged` option to [docker run](https://docs.docker.com/engine/reference/run/). The default value is false.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
         */
        public var privileged: kotlin.Boolean? = null
        /**
         * When this parameter is true, the container is given read-only access to its root file system. This parameter maps to `ReadonlyRootfs` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--read-only` option to `docker run`.
         */
        public var readonlyRootFilesystem: kotlin.Boolean? = null
        /**
         * The type and amount of resources to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
         */
        public var resourceRequirements: List<ResourceRequirement>? = null
        /**
         * The secrets for the container. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html) in the *Batch User Guide*.
         */
        public var secrets: List<Secret>? = null
        /**
         * A list of `ulimits` to set in the container. This parameter maps to `Ulimits` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--ulimit` option to [docker run](https://docs.docker.com/engine/reference/run/).
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         */
        public var ulimits: List<Ulimit>? = null
        /**
         * The user name to use inside the container. This parameter maps to `User` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--user` option to [docker run](https://docs.docker.com/engine/reference/run/).
         */
        public var user: kotlin.String? = null
        /**
         * This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition. It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the number of vCPUs reserved for the job.
         *
         * Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to `CpuShares` in the [Create a container](https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.docker.com/engine/reference/run/). The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var vcpus: kotlin.Int? = null
        /**
         * A list of data volumes used in a job.
         */
        public var volumes: List<Volume>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ContainerProperties) : this() {
            this.command = x.command
            this.environment = x.environment
            this.executionRoleArn = x.executionRoleArn
            this.fargatePlatformConfiguration = x.fargatePlatformConfiguration
            this.image = x.image
            this.instanceType = x.instanceType
            this.jobRoleArn = x.jobRoleArn
            this.linuxParameters = x.linuxParameters
            this.logConfiguration = x.logConfiguration
            this.memory = x.memory
            this.mountPoints = x.mountPoints
            this.networkConfiguration = x.networkConfiguration
            this.privileged = x.privileged
            this.readonlyRootFilesystem = x.readonlyRootFilesystem
            this.resourceRequirements = x.resourceRequirements
            this.secrets = x.secrets
            this.ulimits = x.ulimits
            this.user = x.user
            this.vcpus = x.vcpus
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ContainerProperties = ContainerProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration] inside the given [block]
         */
        public fun fargatePlatformConfiguration(block: aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration.Builder.() -> kotlin.Unit) {
            this.fargatePlatformConfiguration = aws.sdk.kotlin.services.batch.model.FargatePlatformConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.LinuxParameters] inside the given [block]
         */
        public fun linuxParameters(block: aws.sdk.kotlin.services.batch.model.LinuxParameters.Builder.() -> kotlin.Unit) {
            this.linuxParameters = aws.sdk.kotlin.services.batch.model.LinuxParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.LogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.batch.model.LogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.batch.model.LogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.batch.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.batch.model.NetworkConfiguration.invoke(block)
        }
    }
}
