// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `CreateJobQueue`.
 */
public class CreateJobQueueRequest private constructor(builder: Builder) {
    /**
     * The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the `VALID` state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
     *
     * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue.
     */
    public val computeEnvironmentOrder: List<ComputeEnvironmentOrder>? = builder.computeEnvironmentOrder
    /**
     * The name of the job queue. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public val jobQueueName: kotlin.String? = builder.jobQueueName
    /**
     * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1`. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy. The format is `aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> `. An example is `aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy`.
     */
    public val schedulingPolicyArn: kotlin.String? = builder.schedulingPolicyArn
    /**
     * The state of the job queue. If the job queue state is `ENABLED`, it is able to accept jobs. If the job queue state is `DISABLED`, new jobs can't be added to the queue, but jobs already in the queue can finish.
     */
    public val state: aws.sdk.kotlin.services.batch.model.JqState? = builder.state
    /**
     * The tags that you apply to the job queue to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging your Batch resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html) in *Batch User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.CreateJobQueueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobQueueRequest(")
        append("computeEnvironmentOrder=$computeEnvironmentOrder,")
        append("jobQueueName=$jobQueueName,")
        append("priority=$priority,")
        append("schedulingPolicyArn=$schedulingPolicyArn,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironmentOrder?.hashCode() ?: 0
        result = 31 * result + (jobQueueName?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (schedulingPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobQueueRequest

        if (computeEnvironmentOrder != other.computeEnvironmentOrder) return false
        if (jobQueueName != other.jobQueueName) return false
        if (priority != other.priority) return false
        if (schedulingPolicyArn != other.schedulingPolicyArn) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.CreateJobQueueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the `VALID` state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
         *
         * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue.
         */
        public var computeEnvironmentOrder: List<ComputeEnvironmentOrder>? = null
        /**
         * The name of the job queue. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         */
        public var jobQueueName: kotlin.String? = null
        /**
         * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1`. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
         */
        public var priority: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy. The format is `aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> `. An example is `aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy`.
         */
        public var schedulingPolicyArn: kotlin.String? = null
        /**
         * The state of the job queue. If the job queue state is `ENABLED`, it is able to accept jobs. If the job queue state is `DISABLED`, new jobs can't be added to the queue, but jobs already in the queue can finish.
         */
        public var state: aws.sdk.kotlin.services.batch.model.JqState? = null
        /**
         * The tags that you apply to the job queue to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging your Batch resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html) in *Batch User Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.CreateJobQueueRequest) : this() {
            this.computeEnvironmentOrder = x.computeEnvironmentOrder
            this.jobQueueName = x.jobQueueName
            this.priority = x.priority
            this.schedulingPolicyArn = x.schedulingPolicyArn
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.CreateJobQueueRequest = CreateJobQueueRequest(this)
    }
}
