// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `DescribeComputeEnvironments`.
 */
public class DescribeComputeEnvironmentsRequest private constructor(builder: Builder) {
    /**
     * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
     */
    public val computeEnvironments: List<String>? = builder.computeEnvironments
    /**
     * The maximum number of cluster results returned by `DescribeComputeEnvironments` in paginated output. When this parameter is used, `DescribeComputeEnvironments` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeComputeEnvironments` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `DescribeComputeEnvironments` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `DescribeComputeEnvironments` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
     *
     * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.DescribeComputeEnvironmentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeComputeEnvironmentsRequest(")
        append("computeEnvironments=$computeEnvironments,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironments?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeComputeEnvironmentsRequest

        if (computeEnvironments != other.computeEnvironments) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.DescribeComputeEnvironmentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         */
        public var computeEnvironments: List<String>? = null
        /**
         * The maximum number of cluster results returned by `DescribeComputeEnvironments` in paginated output. When this parameter is used, `DescribeComputeEnvironments` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeComputeEnvironments` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `DescribeComputeEnvironments` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `DescribeComputeEnvironments` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
         *
         * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.DescribeComputeEnvironmentsRequest) : this() {
            this.computeEnvironments = x.computeEnvironments
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.DescribeComputeEnvironmentsRequest = DescribeComputeEnvironmentsRequest(this)
    }
}
