// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object representing the details of an Batch job queue.
 */
public class JobQueueDetail private constructor(builder: Builder) {
    /**
     * The compute environments that are attached to the job queue and the order that job placement is preferred. Compute environments are selected for job placement in ascending order.
     */
    public val computeEnvironmentOrder: List<ComputeEnvironmentOrder>? = builder.computeEnvironmentOrder
    /**
     * The Amazon Resource Name (ARN) of the job queue.
     */
    public val jobQueueArn: kotlin.String? = builder.jobQueueArn
    /**
     * The name of the job queue.
     */
    public val jobQueueName: kotlin.String? = builder.jobQueueName
    /**
     * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1`. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the scheduling policy. The format is `aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> `. For example, `aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy`.
     */
    public val schedulingPolicyArn: kotlin.String? = builder.schedulingPolicyArn
    /**
     * Describes the ability of the queue to accept new jobs. If the job queue state is `ENABLED`, it's able to accept jobs. If the job queue state is `DISABLED`, new jobs can't be added to the queue, but jobs already in the queue can finish.
     */
    public val state: aws.sdk.kotlin.services.batch.model.JqState? = builder.state
    /**
     * The status of the job queue (for example, `CREATING` or `VALID`).
     */
    public val status: aws.sdk.kotlin.services.batch.model.JqStatus? = builder.status
    /**
     * A short, human-readable string to provide additional details about the current status of the job queue.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The tags applied to the job queue. For more information, see [Tagging your Batch resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html) in *Batch User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.JobQueueDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobQueueDetail(")
        append("computeEnvironmentOrder=$computeEnvironmentOrder,")
        append("jobQueueArn=$jobQueueArn,")
        append("jobQueueName=$jobQueueName,")
        append("priority=$priority,")
        append("schedulingPolicyArn=$schedulingPolicyArn,")
        append("state=$state,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironmentOrder?.hashCode() ?: 0
        result = 31 * result + (jobQueueArn?.hashCode() ?: 0)
        result = 31 * result + (jobQueueName?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (schedulingPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobQueueDetail

        if (computeEnvironmentOrder != other.computeEnvironmentOrder) return false
        if (jobQueueArn != other.jobQueueArn) return false
        if (jobQueueName != other.jobQueueName) return false
        if (priority != other.priority) return false
        if (schedulingPolicyArn != other.schedulingPolicyArn) return false
        if (state != other.state) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.JobQueueDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The compute environments that are attached to the job queue and the order that job placement is preferred. Compute environments are selected for job placement in ascending order.
         */
        public var computeEnvironmentOrder: List<ComputeEnvironmentOrder>? = null
        /**
         * The Amazon Resource Name (ARN) of the job queue.
         */
        public var jobQueueArn: kotlin.String? = null
        /**
         * The name of the job queue.
         */
        public var jobQueueName: kotlin.String? = null
        /**
         * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1`. All of the compute environments must be either EC2 (`EC2` or `SPOT`) or Fargate (`FARGATE` or `FARGATE_SPOT`); EC2 and Fargate compute environments can't be mixed.
         */
        public var priority: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the scheduling policy. The format is `aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> `. For example, `aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy`.
         */
        public var schedulingPolicyArn: kotlin.String? = null
        /**
         * Describes the ability of the queue to accept new jobs. If the job queue state is `ENABLED`, it's able to accept jobs. If the job queue state is `DISABLED`, new jobs can't be added to the queue, but jobs already in the queue can finish.
         */
        public var state: aws.sdk.kotlin.services.batch.model.JqState? = null
        /**
         * The status of the job queue (for example, `CREATING` or `VALID`).
         */
        public var status: aws.sdk.kotlin.services.batch.model.JqStatus? = null
        /**
         * A short, human-readable string to provide additional details about the current status of the job queue.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The tags applied to the job queue. For more information, see [Tagging your Batch resources](https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html) in *Batch User Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.JobQueueDetail) : this() {
            this.computeEnvironmentOrder = x.computeEnvironmentOrder
            this.jobQueueArn = x.jobQueueArn
            this.jobQueueName = x.jobQueueName
            this.priority = x.priority
            this.schedulingPolicyArn = x.schedulingPolicyArn
            this.state = x.state
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.JobQueueDetail = JobQueueDetail(this)
    }
}
