// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `ListJobs`.
 */
public class ListJobsRequest private constructor(builder: Builder) {
    /**
     * The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within the specified array.
     */
    public val arrayJobId: kotlin.String? = builder.arrayJobId
    /**
     * The filter to apply to the query. Only one filter can be used at a time. When the filter is used, `jobStatus` is ignored. The filter doesn't apply to child jobs in an array or multi-node parallel (MNP) jobs. The results are sorted by the `createdAt` field, with the most recent jobs being first.
     *
     * ## JOB_NAME
     * The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*), the filter will match any job name that begins with the string before the '*'. This corresponds to the `jobName` value. For example, `test1` matches both `Test1` and `test1`, and `test1*` matches both `test1` and `Test10`. When the `JOB_NAME` filter is used, the results are grouped by the job name and version.
     *
     * ## JOB_DEFINITION
     * The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to the `jobDefinition` value. The value is case sensitive. When the value for the filter is the job definition name, the results include all the jobs that used any revision of that job definition name. If the value ends with an asterisk (*), the filter will match any job definition name that begins with the string before the '*'. For example, `jd1` matches only `jd1`, and `jd1*` matches both `jd1` and `jd1A`. The version of the job definition that's used doesn't affect the sort order. When the `JOB_DEFINITION` filter is used and the ARN is used (which is in the form `arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}`), the results include jobs that used the specified revision of the job definition. Asterisk (*) is not supported when the ARN is used.
     *
     * ## BEFORE_CREATED_AT
     * The value for the filter is the time that's before the job was created. This corresponds to the `createdAt` value. The value is a string representation of the number of milliseconds since 00:00:00 UTC (midnight) on January 1, 1970.
     *
     * ## AFTER_CREATED_AT
     * The value for the filter is the time that's after the job was created. This corresponds to the `createdAt` value. The value is a string representation of the number of milliseconds since 00:00:00 UTC (midnight) on January 1, 1970.
     */
    public val filters: List<KeyValuesPair>? = builder.filters
    /**
     * The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.
     */
    public val jobQueue: kotlin.String? = builder.jobQueue
    /**
     * The job status used to filter jobs in the specified queue. If the `filters` parameter is specified, the `jobStatus` parameter is ignored and jobs with any status are returned. If you don't specify a status, only `RUNNING` jobs are returned.
     */
    public val jobStatus: aws.sdk.kotlin.services.batch.model.JobStatus? = builder.jobStatus
    /**
     * The maximum number of results returned by `ListJobs` in paginated output. When this parameter is used, `ListJobs` only returns `maxResults` results in a single page and a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListJobs` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListJobs` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists all nodes that are associated with the specified job.
     */
    public val multiNodeJobId: kotlin.String? = builder.multiNodeJobId
    /**
     * The `nextToken` value returned from a previous paginated `ListJobs` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
     *
     * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ListJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListJobsRequest(")
        append("arrayJobId=$arrayJobId,")
        append("filters=$filters,")
        append("jobQueue=$jobQueue,")
        append("jobStatus=$jobStatus,")
        append("maxResults=$maxResults,")
        append("multiNodeJobId=$multiNodeJobId,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrayJobId?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (jobQueue?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (multiNodeJobId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListJobsRequest

        if (arrayJobId != other.arrayJobId) return false
        if (filters != other.filters) return false
        if (jobQueue != other.jobQueue) return false
        if (jobStatus != other.jobStatus) return false
        if (maxResults != other.maxResults) return false
        if (multiNodeJobId != other.multiNodeJobId) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ListJobsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within the specified array.
         */
        public var arrayJobId: kotlin.String? = null
        /**
         * The filter to apply to the query. Only one filter can be used at a time. When the filter is used, `jobStatus` is ignored. The filter doesn't apply to child jobs in an array or multi-node parallel (MNP) jobs. The results are sorted by the `createdAt` field, with the most recent jobs being first.
         *
         * ## JOB_NAME
         * The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*), the filter will match any job name that begins with the string before the '*'. This corresponds to the `jobName` value. For example, `test1` matches both `Test1` and `test1`, and `test1*` matches both `test1` and `Test10`. When the `JOB_NAME` filter is used, the results are grouped by the job name and version.
         *
         * ## JOB_DEFINITION
         * The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to the `jobDefinition` value. The value is case sensitive. When the value for the filter is the job definition name, the results include all the jobs that used any revision of that job definition name. If the value ends with an asterisk (*), the filter will match any job definition name that begins with the string before the '*'. For example, `jd1` matches only `jd1`, and `jd1*` matches both `jd1` and `jd1A`. The version of the job definition that's used doesn't affect the sort order. When the `JOB_DEFINITION` filter is used and the ARN is used (which is in the form `arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}`), the results include jobs that used the specified revision of the job definition. Asterisk (*) is not supported when the ARN is used.
         *
         * ## BEFORE_CREATED_AT
         * The value for the filter is the time that's before the job was created. This corresponds to the `createdAt` value. The value is a string representation of the number of milliseconds since 00:00:00 UTC (midnight) on January 1, 1970.
         *
         * ## AFTER_CREATED_AT
         * The value for the filter is the time that's after the job was created. This corresponds to the `createdAt` value. The value is a string representation of the number of milliseconds since 00:00:00 UTC (midnight) on January 1, 1970.
         */
        public var filters: List<KeyValuesPair>? = null
        /**
         * The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.
         */
        public var jobQueue: kotlin.String? = null
        /**
         * The job status used to filter jobs in the specified queue. If the `filters` parameter is specified, the `jobStatus` parameter is ignored and jobs with any status are returned. If you don't specify a status, only `RUNNING` jobs are returned.
         */
        public var jobStatus: aws.sdk.kotlin.services.batch.model.JobStatus? = null
        /**
         * The maximum number of results returned by `ListJobs` in paginated output. When this parameter is used, `ListJobs` only returns `maxResults` results in a single page and a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListJobs` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListJobs` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists all nodes that are associated with the specified job.
         */
        public var multiNodeJobId: kotlin.String? = null
        /**
         * The `nextToken` value returned from a previous paginated `ListJobs` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
         *
         * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ListJobsRequest) : this() {
            this.arrayJobId = x.arrayJobId
            this.filters = x.filters
            this.jobQueue = x.jobQueue
            this.jobStatus = x.jobStatus
            this.maxResults = x.maxResults
            this.multiNodeJobId = x.multiNodeJobId
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ListJobsRequest = ListJobsRequest(this)
    }
}
