// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Object representing any node overrides to a job definition that's used in a SubmitJob API operation.
 *
 * This isn't applicable to jobs that are running on Fargate resources and shouldn't be provided; use `containerOverrides` instead.
 */
public class NodeOverrides private constructor(builder: Builder) {
    /**
     * The node property overrides for the job.
     */
    public val nodePropertyOverrides: List<NodePropertyOverride>? = builder.nodePropertyOverrides
    /**
     * The number of nodes to use with a multi-node parallel job. This value overrides the number of nodes that are specified in the job definition. To use this override:
     * + There must be at least one node range in your job definition that has an open upper boundary (such as `:` or `n:`).
     * + The lower boundary of the node range specified in the job definition must be fewer than the number of nodes specified in the override.
     * + The main node index specified in the job definition must be fewer than the number of nodes specified in the override.
     */
    public val numNodes: kotlin.Int? = builder.numNodes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.NodeOverrides = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeOverrides(")
        append("nodePropertyOverrides=$nodePropertyOverrides,")
        append("numNodes=$numNodes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = nodePropertyOverrides?.hashCode() ?: 0
        result = 31 * result + (numNodes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeOverrides

        if (nodePropertyOverrides != other.nodePropertyOverrides) return false
        if (numNodes != other.numNodes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.NodeOverrides = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The node property overrides for the job.
         */
        public var nodePropertyOverrides: List<NodePropertyOverride>? = null
        /**
         * The number of nodes to use with a multi-node parallel job. This value overrides the number of nodes that are specified in the job definition. To use this override:
         * + There must be at least one node range in your job definition that has an open upper boundary (such as `:` or `n:`).
         * + The lower boundary of the node range specified in the job definition must be fewer than the number of nodes specified in the override.
         * + The main node index specified in the job definition must be fewer than the number of nodes specified in the override.
         */
        public var numNodes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.NodeOverrides) : this() {
            this.nodePropertyOverrides = x.nodePropertyOverrides
            this.numNodes = x.numNodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.NodeOverrides = NodeOverrides(this)
    }
}
